/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.data;

import com.axelor.data.ImportException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public abstract class ImportTask {
    public Multimap<String, Reader> readers = ArrayListMultimap.create();

    public abstract void configure() throws IOException;

    public boolean handle(ImportException e) {
        return false;
    }

    public boolean handle(IOException e) {
        return false;
    }

    public boolean handle(ClassNotFoundException e) {
        return false;
    }

    public void input(String inputName, File source) throws FileNotFoundException {
        this.input(inputName, source, Charset.defaultCharset());
    }

    public void input(String inputName, File source, Charset charset) throws FileNotFoundException {
        this.input(inputName, new FileInputStream(source), charset);
    }

    public void input(String inputName, InputStream source) {
        this.input(inputName, source, Charset.defaultCharset());
    }

    public void input(String inputName, InputStream source, Charset charset) {
        this.input(inputName, new InputStreamReader(source, charset));
    }

    public void input(String inputName, Reader reader) {
        this.readers.put((Object)inputName, (Object)reader);
    }
}

