/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.data.adapter;

import com.axelor.data.adapter.Adapter;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@XStreamAlias(value="adapter")
public class DataAdapter {
    @XStreamAsAttribute
    private String name;
    @XStreamAlias(value="type")
    @XStreamAsAttribute
    private String klass;
    @XStreamImplicit
    @XStreamAlias(value="option")
    private List<Option> options;
    private Adapter adapter;

    public DataAdapter() {
    }

    public DataAdapter(String name, Class<?> type, String ... options) {
        this.name = name;
        this.klass = type.getName();
        this.options = Lists.newArrayList();
        if (options.length % 2 == 0) {
            for (int i = 0; i < options.length; i += 2) {
                String key = options[i];
                String val = options[i + 1];
                Option opt = new Option();
                opt.name = key;
                opt.value = val;
                this.options.add(opt);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        try {
            return Class.forName(this.klass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No such adapter: " + this.klass);
        }
    }

    private Adapter create() {
        Class<?> type = this.getType();
        try {
            return (Adapter)type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid adapter: " + this.klass);
        }
    }

    public Object adapt(Object value, Map<String, Object> context) {
        if (this.adapter == null) {
            this.adapter = this.create();
            if (this.options != null) {
                Properties p = new Properties();
                for (Option o : this.options) {
                    p.setProperty(o.name, o.value);
                }
                this.adapter.setOptions(p);
            }
        }
        return this.adapter.adapt(value, context);
    }

    static class Option {
        @XStreamAsAttribute
        String name;
        @XStreamAsAttribute
        String value;

        Option() {
        }

        public String toString() {
            return "{ " + this.name + " : " + this.value + " }";
        }
    }
}

