/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.data.csv;

import com.axelor.data.AuditHelper;
import com.axelor.data.adapter.DataAdapter;
import com.axelor.data.csv.CSVBind;
import com.axelor.data.csv.CSVInput;
import com.axelor.db.JPA;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.db.mapper.PropertyType;
import com.axelor.inject.Beans;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVBinder {
    private static final Logger LOG = LoggerFactory.getLogger(CSVBinder.class);
    private Class<?> beanClass;
    private List<CSVBind> bindings;
    private String[] fields;
    private String query;
    private boolean update;
    private boolean newBean;
    private String searchCall;
    private Map<String, DataAdapter> adapters = Maps.newHashMap();
    private Object callSearchObject;
    private Method callSearchMethod;

    public void registerAdapter(DataAdapter adapter) {
        this.adapters.put(adapter.getName(), adapter);
    }

    public void registerAdapters(Map<String, DataAdapter> map) {
        this.adapters.putAll(map);
    }

    public String[] getFields() {
        return this.fields;
    }

    public CSVBinder(Class<?> beanClass, String[] fields, CSVInput csvInput) {
        this(beanClass, fields, csvInput.getBindings(), true, csvInput.getSearch(), csvInput.isUpdate(), csvInput.getSearchCall());
    }

    public CSVBinder(Class<?> beanClass, String[] fields, CSVBind csvBind) {
        this(beanClass, fields, csvBind.getBindings(), false, csvBind.getSearch(), csvBind.isUpdate(), null);
    }

    private CSVBinder(Class<?> beanClass, String[] fields, List<CSVBind> csvBinds, boolean autoBind, String query, boolean update, String searchCall) {
        this.beanClass = beanClass;
        this.fields = fields;
        this.bindings = Lists.newArrayList();
        this.query = query;
        this.update = update;
        this.searchCall = searchCall;
        if (csvBinds != null) {
            this.bindings.addAll(csvBinds);
        }
        if (autoBind) {
            this.autoBind(fields);
        }
    }

    private void autoBind(String[] fields) {
        HashSet beanFields = Sets.newHashSet();
        HashMap refFields = Maps.newHashMap();
        List<String> boundCols = this.getBoundCols(this.bindings, null);
        for (String field : fields) {
            if (boundCols.contains(field)) continue;
            if (field.contains(".")) {
                String[] parts = field.split("\\.");
                beanFields.add(parts[0]);
                HashSet<String> refs = (HashSet<String>)refFields.get(parts[0]);
                if (refs == null) {
                    refs = new HashSet<String>();
                    refFields.put(parts[0], refs);
                }
                refs.add(parts[1]);
                continue;
            }
            beanFields.add(field);
        }
        for (String field : beanFields) {
            this.bindings.add(CSVBind.getBinding(null, field, (Set)refFields.get(field)));
        }
    }

    private List<String> getBoundCols(List<CSVBind> bindings, List<String> bounds) {
        if (bounds == null) {
            bounds = Lists.newArrayList();
        }
        if (bindings != null) {
            for (CSVBind cb : bindings) {
                if (cb.getColumn() != null) {
                    bounds.add(cb.getColumn());
                }
                if (cb.getBindings() == null) continue;
                bounds.addAll(this.getBoundCols(cb.getBindings(), bounds));
            }
        }
        return bounds;
    }

    private Object find(Map<String, Object> params) {
        Object bean;
        if (this.searchCall != null) {
            LOG.trace("call bean search: " + this.searchCall);
            bean = this.callSearch(params);
            LOG.trace("search found: " + bean);
            if (this.update || bean != null) {
                this.newBean = false;
                return bean;
            }
        } else if (this.query != null) {
            LOG.trace("search: " + this.query);
            bean = JPA.all(this.beanClass).filter(this.query).bind(params).cacheable().autoFlush(false).fetchOne();
            LOG.trace("search found: " + bean);
            if (this.update || bean != null) {
                this.newBean = false;
                return bean;
            }
        }
        try {
            this.newBean = true;
            return this.beanClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T callSearch(Map<String, Object> context) {
        if (Strings.isNullOrEmpty((String)this.searchCall)) {
            return null;
        }
        try {
            if (this.callSearchObject == null) {
                String className = this.searchCall.split("\\:")[0];
                String method = this.searchCall.split("\\:")[1];
                Class<?> klass = Class.forName(className);
                this.callSearchMethod = klass.getMethod(method, Map.class);
                this.callSearchObject = Beans.get(klass);
            }
            return (T)this.callSearchMethod.invoke(this.callSearchObject, context);
        }
        catch (Exception e) {
            System.err.println("EEE: " + e);
            return null;
        }
    }

    private Object findAll(Class<?> beanClass, String query, Map<String, Object> params) {
        return JPA.all(beanClass).filter(query).bind(params).cacheable().autoFlush(false).fetch();
    }

    private boolean isBound(CSVBind cb, Map<String, Object> values) {
        if (cb.getColumn() != null) {
            return values.get(cb.getColumn()) != null;
        }
        if (cb.getBindings() != null) {
            for (CSVBind b : cb.getBindings()) {
                if (!this.isBound(b, values)) continue;
                return true;
            }
        }
        if (cb.getSearch() != null) {
            return true;
        }
        return cb.getExpression() != null;
    }

    private void handleDummyBind(CSVBind cb, Map<String, Object> values) {
        Class<?> type = null;
        try {
            type = Class.forName(cb.getType());
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        String field = cb.getField();
        Object value = null;
        if (type == null) {
            value = values.get(cb.getColumn());
            if (cb.getColumn() == null && cb.getSearch() == null && cb.getExpression() != null) {
                value = cb.evaluate(values);
            }
        } else {
            CSVBinder binder = new CSVBinder(type, this.fields, cb);
            binder.registerAdapters(this.adapters);
            value = binder.bind(values);
        }
        values.put(field, value);
    }

    private Object bind(Map<String, Object> values) {
        Mapper mapper = Mapper.of(this.beanClass);
        Object bean = this.find(values);
        if (bean == null) {
            return null;
        }
        LOG.trace("populate: " + this.beanClass);
        for (CSVBind cb : this.bindings) {
            LOG.trace("binding: " + cb);
            String field = cb.getField();
            Property p = mapper.getProperty(field);
            if (p == null) {
                this.handleDummyBind(cb, values);
                continue;
            }
            if (p.isPrimary() || p.isVirtual() || !this.isBound(cb, values)) continue;
            Object value = values.get(cb.getColumn());
            LOG.trace("value: " + value);
            LOG.trace("condition: " + cb.getCondition());
            if (!this.newBean && cb.getConditionEmpty() == Boolean.TRUE) {
                Object o = p.get(bean);
                if (o != null && p.isCollection()) {
                    if (o instanceof Collection && !((Collection)o).isEmpty()) {
                        LOG.trace("field is not empty");
                        continue;
                    }
                } else if (o != null) {
                    LOG.trace("field is not empty");
                    continue;
                }
            }
            if (!cb.validate(values)) {
                LOG.trace("condition failed");
                continue;
            }
            value = this.adapt(cb, value, values);
            if (cb.getColumn() == null && cb.getSearch() == null && cb.getExpression() != null) {
                LOG.trace("expression: " + cb.getExpression());
                value = cb.evaluate(values);
                LOG.trace("value: " + value);
            } else if (p.getType() == PropertyType.MANY_TO_MANY && cb.getColumn() != null && cb.getSearch() != null) {
                value = this.findAll(p.getTarget(), cb.getSearch(), values);
            } else if (p.getTarget() != null) {
                CSVBinder b = new CSVBinder(p.getTarget(), this.fields, cb);
                b.registerAdapters(this.adapters);
                value = b.bind(values);
            }
            if (p.isCollection()) {
                if (value != null) {
                    if (value instanceof Collection) {
                        p.addAll(bean, (Collection)value);
                    } else {
                        p.add(bean, value);
                    }
                }
            } else if (!AuditHelper.update(bean, field, value)) {
                p.set(bean, value);
            }
            if (value == null && (p.isReference() || p.isCollection()) && this.isValueGiven(cb, values)) {
                LOG.warn("Bind null value to {} with context: {}", (Object)p.getName(), Arrays.asList(values));
                continue;
            }
            LOG.trace("set value: {} = {}", (Object)p.getName(), value);
        }
        return bean;
    }

    private boolean isValueGiven(CSVBind bind, Map<String, Object> values) {
        if (bind.getColumn() != null) {
            return false;
        }
        if (bind.getBindings() == null) {
            return true;
        }
        boolean given = false;
        for (CSVBind binding : bind.getBindings()) {
            Object raw = values.get(binding.getColumn());
            if (raw == null || "".equals(raw)) continue;
            given = true;
            break;
        }
        return given;
    }

    public Object bind(String[] values, Map<String, Object> localContext) {
        Preconditions.checkNotNull((Object)values);
        Preconditions.checkNotNull(localContext);
        Preconditions.checkArgument((values.length == this.fields.length ? 1 : 0) != 0);
        HashMap map = Maps.newHashMap(localContext);
        for (int i = 0; i < this.fields.length; ++i) {
            map.put(this.fields[i], values[i]);
        }
        localContext.putAll(map);
        for (CSVBind cb : this.flatten(this.bindings)) {
            String field = cb.getColumn();
            if (Strings.isNullOrEmpty((String)field)) continue;
            localContext.put(field, cb.evaluate(map));
            if (!field.contains(".")) continue;
            localContext.put(field.replace(".", "_") + "_", localContext.get(field));
        }
        return this.bind(localContext);
    }

    private List<CSVBind> flatten(List<CSVBind> bindings) {
        ArrayList all = Lists.newArrayList();
        for (CSVBind cb : bindings) {
            all.add(cb);
            if (cb.getBindings() == null) continue;
            all.addAll(this.flatten(cb.getBindings()));
        }
        return all;
    }

    private Object adapt(CSVBind bind, Object value, Map<String, Object> ctx) {
        String name = bind.getAdapter();
        if ("".equals(value)) {
            value = null;
        }
        if (name == null || !this.adapters.containsKey(name)) {
            return value;
        }
        DataAdapter adapter = this.adapters.get(name);
        return adapter.adapt(value, ctx);
    }
}

