/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.data.csv;

import com.axelor.common.StringUtils;
import com.axelor.data.ImportException;
import com.axelor.data.ImportTask;
import com.axelor.data.Importer;
import com.axelor.data.Listener;
import com.axelor.data.adapter.DataAdapter;
import com.axelor.data.csv.CSVBinder;
import com.axelor.data.csv.CSVConfig;
import com.axelor.data.csv.CSVInput;
import com.axelor.data.csv.CSVLogger;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.internal.DBHelper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVImporter
implements Importer {
    private Logger LOG = LoggerFactory.getLogger(this.getClass());
    private File dataDir;
    private CSVConfig config;
    private List<Listener> listeners = Lists.newArrayList();
    private List<String[]> valuesStack = Lists.newArrayList();
    private Map<String, Object> context;
    private CSVLogger loggerManager;

    @Override
    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void clearListener() {
        this.listeners.clear();
    }

    @Override
    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    public CSVImporter(String configFile) {
        this(configFile, null, null);
    }

    public CSVImporter(String config, String dataDir) {
        this(config, dataDir, null);
    }

    @Inject
    public CSVImporter(@Named(value="axelor.data.config") String config, @Named(value="axelor.data.dir") String dataDir, @Nullable @Named(value="axelor.error.dir") String errorDir) {
        File _file = new File(config);
        Preconditions.checkNotNull((Object)_file);
        Preconditions.checkArgument((boolean)_file.isFile());
        if (dataDir != null) {
            File _data = new File(dataDir);
            Preconditions.checkNotNull((Object)_data);
            Preconditions.checkArgument((boolean)_data.isDirectory());
            this.dataDir = _data;
        }
        this.config = CSVConfig.parse(_file);
        if (!Strings.isNullOrEmpty((String)errorDir)) {
            this.loggerManager = new CSVLogger(this.config, errorDir);
        }
    }

    public CSVImporter(CSVConfig config) {
        this(config, null);
    }

    public CSVImporter(CSVConfig config, String dataDir) {
        this(config, dataDir, null);
    }

    public CSVImporter(CSVConfig config, String dataDir, String errorDir) {
        if (dataDir != null) {
            File _data = new File(dataDir);
            Preconditions.checkNotNull((Object)_data);
            Preconditions.checkArgument((boolean)_data.isDirectory());
            this.dataDir = _data;
        }
        this.config = config;
        if (!Strings.isNullOrEmpty((String)errorDir)) {
            this.loggerManager = new CSVLogger(this.config, errorDir);
        }
    }

    private List<File> getFiles(String ... names) {
        ArrayList all = Lists.newArrayList();
        for (String name : names) {
            all.add(new File(this.dataDir, name));
        }
        return all;
    }

    public CSVLogger getLoggerManager() {
        return this.loggerManager;
    }

    @Override
    public void run(ImportTask task) {
        try {
            if (task.readers.isEmpty()) {
                task.configure();
            }
            block9: for (CSVInput input : this.config.getInputs()) {
                for (Reader reader : task.readers.get((Object)input.getFileName())) {
                    try {
                        this.process(input, reader);
                    }
                    catch (IOException e) {
                        if (this.LOG.isErrorEnabled()) {
                            this.LOG.error("I/O error while accessing {}.", (Object)input.getFileName());
                        }
                        if (task.handle(e)) continue;
                        continue block9;
                    }
                    catch (ClassNotFoundException e) {
                        if (this.LOG.isErrorEnabled()) {
                            this.LOG.error("Error while importing {}.", (Object)input.getFileName());
                            this.LOG.error("No such class found {}.", (Object)input.getTypeName());
                        }
                        if (task.handle(e)) continue;
                        continue block9;
                    }
                    catch (Exception e) {
                        if (task.handle(new ImportException(e))) continue;
                        continue block9;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            task.readers.clear();
        }
    }

    @Override
    public void run() {
        for (CSVInput input : this.config.getInputs()) {
            String fileName = input.getFileName();
            List<File> files = this.getFiles(fileName);
            for (File file : files) {
                try {
                    this.process(input, file);
                }
                catch (IOException e) {
                    if (!this.LOG.isErrorEnabled()) continue;
                    this.LOG.error("Error while accessing {}.", (Object)file);
                }
                catch (ClassNotFoundException e) {
                    if (!this.LOG.isErrorEnabled()) continue;
                    this.LOG.error("Error while importing {}.", (Object)file);
                    this.LOG.error("No such class found {}.", (Object)input.getTypeName());
                }
                catch (Exception e) {
                    if (!this.LOG.isErrorEnabled()) continue;
                    this.LOG.error("Error while importing {}.", (Object)file);
                    this.LOG.error("Unable to import data.");
                    this.LOG.error("With following exception:", (Throwable)e);
                }
            }
        }
    }

    private boolean isEmpty(String[] line) {
        if (line == null || line.length == 0) {
            return true;
        }
        return line.length == 1 && (line[0] == null || "".equals(line[0].trim()));
    }

    private void process(CSVInput input, File file) throws IOException, ClassNotFoundException {
        this.process(input, new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(CSVInput csvInput, Reader reader) throws IOException, ClassNotFoundException {
        block22: {
            String beanName = csvInput.getTypeName();
            this.LOG.info("Importing {} from {}", (Object)beanName, (Object)csvInput.getFileName());
            BufferedReader streamReader = new BufferedReader(reader);
            CSVReader csvReader = new CSVReader((Reader)streamReader, csvInput.getSeparator());
            String[] fields = StringUtils.isBlank((CharSequence)csvInput.getHeader()) ? csvReader.readNext() : csvInput.getHeader().trim().split("\\s*,\\s*");
            Class<?> beanClass = Class.forName(beanName);
            if (this.loggerManager != null) {
                this.loggerManager.prepareInput(csvInput, fields);
            }
            this.LOG.debug("Header {}", Arrays.asList(fields));
            CSVBinder binder = new CSVBinder(beanClass, fields, csvInput);
            String[] values = null;
            int count = 0;
            int total = 0;
            int batchSize = DBHelper.getJdbcBatchSize();
            JPA.em().getTransaction().begin();
            try {
                HashMap<String, Object> context = new HashMap<String, Object>();
                if (this.context != null) {
                    context.putAll(this.context);
                }
                csvInput.callPrepareContext(context);
                if (this.dataDir != null) {
                    context.put("__path__", this.dataDir.toPath());
                }
                for (DataAdapter adapter : defaultAdapters) {
                    binder.registerAdapter(adapter);
                }
                for (DataAdapter adapter : this.config.getAdapters()) {
                    binder.registerAdapter(adapter);
                }
                for (DataAdapter adapter : csvInput.getAdapters()) {
                    binder.registerAdapter(adapter);
                }
                while ((values = csvReader.readNext()) != null) {
                    if (this.isEmpty(values)) continue;
                    this.LOG.trace("Record {}", Arrays.asList(values));
                    Object bean = null;
                    try {
                        bean = this.importRow(values, binder, csvInput, (Map<String, Object>)context, false);
                        ++count;
                    }
                    catch (Exception e) {
                        this.LOG.error("Error while importing {}.", (Object)csvInput.getFileName());
                        this.LOG.error("Unable to import record: {}", Arrays.asList(values));
                        this.LOG.error("With following exception:", (Throwable)e);
                        if (JPA.em().getTransaction().isActive()) {
                            JPA.em().getTransaction().rollback();
                        }
                        if (!JPA.em().getTransaction().isActive()) {
                            JPA.em().getTransaction().begin();
                        }
                        for (Listener listener : this.listeners) {
                            listener.handle((Model)bean, e);
                        }
                        this.onRollback(values, binder, csvInput, (Map<String, Object>)context);
                    }
                    ++total;
                    if (this.valuesStack.size() % batchSize != 0) continue;
                    this.LOG.trace("Commit {} records", (Object)this.valuesStack.size());
                    if (JPA.em().getTransaction().isActive()) {
                        JPA.em().getTransaction().commit();
                        JPA.em().clear();
                        this.valuesStack.clear();
                    }
                    if (JPA.em().getTransaction().isActive()) continue;
                    JPA.em().getTransaction().begin();
                }
                if (JPA.em().getTransaction().isActive()) {
                    this.LOG.trace("Commit {} records", (Object)this.valuesStack.size());
                    JPA.em().getTransaction().commit();
                    JPA.em().clear();
                }
            }
            catch (Exception e) {
                if (JPA.em().getTransaction().isActive()) {
                    JPA.em().getTransaction().rollback();
                }
                this.LOG.error("Error while importing {}.", (Object)csvInput.getFileName());
                this.LOG.error("Unable to import data.");
                this.LOG.error("With following exception:", (Throwable)e);
                break block22;
            }
            finally {
                for (Listener listener : this.listeners) {
                    listener.imported(total, count);
                }
                this.valuesStack.clear();
                csvReader.close();
            }
            for (Listener listener : this.listeners) {
                listener.imported(total, count);
            }
            this.valuesStack.clear();
            csvReader.close();
        }
    }

    private Object importRow(String[] values, CSVBinder binder, CSVInput csvInput, Map<String, Object> context, Boolean onRollback) throws Exception {
        Object bean = null;
        HashMap ctx = Maps.newHashMap(context);
        bean = binder.bind(values, ctx);
        bean = csvInput.call(bean, ctx);
        this.LOG.trace("bean created: {}", bean);
        if (bean != null) {
            JPA.manage((Model)bean);
            this.LOG.trace("bean saved: {}", bean);
        }
        if (!onRollback.booleanValue()) {
            this.valuesStack.add(values);
            for (Listener listener : this.listeners) {
                listener.imported((Model)bean);
            }
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRollback(String[] values, CSVBinder binder, CSVInput csvInput, Map<String, Object> context) {
        if (this.loggerManager != null) {
            this.loggerManager.log(values);
        }
        for (String[] row : this.valuesStack) {
            this.LOG.debug("Recover record {}", Arrays.asList(row));
            try {
                this.importRow(row, binder, csvInput, context, true);
                if (!JPA.em().getTransaction().isActive()) continue;
                JPA.em().getTransaction().commit();
            }
            catch (Exception e) {
                if (!JPA.em().getTransaction().isActive()) continue;
                JPA.em().getTransaction().rollback();
            }
            finally {
                if (JPA.em().getTransaction().isActive()) continue;
                JPA.em().getTransaction().begin();
            }
        }
        this.valuesStack.clear();
    }
}

