/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.data.csv;

import com.axelor.data.ImportException;
import com.axelor.data.adapter.DataAdapter;
import com.axelor.data.csv.CSVBind;
import com.axelor.inject.Beans;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

@XStreamAlias(value="input")
public class CSVInput {
    private static final transient char DEFAULT_SEPARATOR = ',';
    @XStreamAlias(value="file")
    @XStreamAsAttribute
    private String fileName;
    @XStreamAsAttribute
    private String header;
    @XStreamAlias(value="type")
    @XStreamAsAttribute
    private String typeName;
    @XStreamAsAttribute
    private String separator;
    @XStreamAsAttribute
    private String search;
    @XStreamAsAttribute
    private boolean update;
    @XStreamAlias(value="call")
    @XStreamAsAttribute
    private String callable;
    @XStreamAlias(value="prepare-context")
    @XStreamAsAttribute
    private String prepareContext;
    @XStreamAlias(value="search-call")
    @XStreamAsAttribute
    private String searchCall;
    @XStreamImplicit(itemFieldName="bind")
    private List<CSVBind> bindings = Lists.newArrayList();
    @XStreamImplicit(itemFieldName="adapter")
    private List<DataAdapter> adapters = Lists.newArrayList();
    private Object callObject;
    private Method callMethod;
    private Object contextObject;
    private Method contextMethod;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public char getSeparator() {
        if (Strings.isNullOrEmpty((String)this.separator)) {
            return ',';
        }
        if ("\\t".equals(this.separator)) {
            return '\t';
        }
        return this.separator.charAt(0);
    }

    public void setSeparator(char separator) {
        this.separator = Character.toString(separator);
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public String getCallable() {
        return this.callable;
    }

    public void setCallable(String callable) {
        this.callable = callable;
    }

    public String getPrepareContext() {
        return this.prepareContext;
    }

    public void setSearchCall(String searchCall) {
        this.searchCall = searchCall;
    }

    public String getSearchCall() {
        return this.searchCall;
    }

    public List<CSVBind> getBindings() {
        return this.bindings;
    }

    public void setBindings(List<CSVBind> bindings) {
        this.bindings = bindings;
    }

    public List<DataAdapter> getAdapters() {
        if (this.adapters == null) {
            this.adapters = Lists.newArrayList();
        }
        return this.adapters;
    }

    public <T> T call(T object, Map<String, Object> context) throws Exception {
        if (Strings.isNullOrEmpty((String)this.callable)) {
            return object;
        }
        if (this.callObject == null) {
            String className = this.callable.split("\\:")[0];
            String method = this.callable.split("\\:")[1];
            Class<?> klass = Class.forName(className);
            this.callMethod = klass.getMethod(method, Object.class, Map.class);
            this.callObject = Beans.get(klass);
        }
        try {
            return (T)this.callMethod.invoke(this.callObject, object, context);
        }
        catch (Exception e) {
            System.err.println("EEE: " + e);
            throw new ImportException(e);
        }
    }

    public Map<String, Object> callPrepareContext(Map<String, Object> context) throws Exception {
        if (Strings.isNullOrEmpty((String)this.prepareContext)) {
            return context;
        }
        if (this.contextObject == null) {
            String className = this.prepareContext.split("\\:")[0];
            String method = this.prepareContext.split("\\:")[1];
            Class<?> klass = Class.forName(className);
            this.contextMethod = klass.getMethod(method, Map.class);
            this.contextObject = Beans.get(klass);
        }
        try {
            this.contextMethod.invoke(this.contextObject, context);
            return context;
        }
        catch (Exception e) {
            System.err.println("EEE: " + e);
            throw new ImportException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("file", (Object)this.fileName).add("type", (Object)this.typeName).add("bindings", this.bindings).omitNullValues().toString();
    }
}

