/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.data.csv;

import com.axelor.data.XStreamUtils;
import com.axelor.data.adapter.DataAdapter;
import com.axelor.data.csv.CSVConfig;
import com.axelor.data.csv.CSVInput;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVLogger {
    private static final String REMOTE_SCHEMA = "data-import_" + CSVConfig.VERSION + ".xsd";
    private static final String DEFAULT_CONFIG_NAME = "csv-config.xml";
    private Logger LOG = LoggerFactory.getLogger(this.getClass());
    private File errorDir;
    private CSVInput csvInput;
    private CSVConfig csvConfig;
    private String[] header;
    private File currentFile;
    private File configFile;
    private List<String> filesName = Lists.newArrayList();
    private boolean inputExported;

    public CSVLogger(CSVConfig csvConfig, String dir) {
        this.errorDir = this.computeDir(dir);
        this.csvConfig = csvConfig;
        this.cleanDir(this.errorDir);
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    private void cleanDir(File file) {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                String[] files;
                for (String temp : files = file.list()) {
                    File fileDelete = new File(file, temp);
                    this.cleanDir(fileDelete);
                }
                if (file.list().length == 0) {
                    file.delete();
                }
            }
        } else {
            file.delete();
        }
    }

    private File computeDir(String errorDir) {
        return new File(Files.simplifyPath((String)errorDir));
    }

    public void log(String[] values) {
        if (this.errorDir == null || this.currentFile == null || this.csvInput == null) {
            return;
        }
        this.exportInput();
        try {
            if (!this.currentFile.exists()) {
                Files.createParentDirs((File)this.currentFile);
                Files.asCharSink((File)this.currentFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).write((CharSequence)Joiner.on((char)this.csvInput.getSeparator()).join(this.transformLine(this.header)));
                this.filesName.add(this.currentFile.getName());
            }
            Files.asCharSink((File)this.configFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).write((CharSequence)("\n" + Joiner.on((char)this.csvInput.getSeparator()).join(this.transformLine(values))));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Collection<String> transformLine(String[] values) {
        return Collections2.transform(Arrays.asList(values), (Function)new Function<String, String>(){

            public String apply(String value) {
                return "\"" + value + "\"";
            }
        });
    }

    public void prepareInput(CSVInput csvInput, String[] fields) {
        this.header = fields;
        this.csvInput = csvInput;
        this.currentFile = this.getCurrentFile(csvInput.getFileName());
        this.inputExported = false;
    }

    private File getCurrentFile(String fileName) {
        if (!this.filesName.contains(this.csvInput.getFileName())) {
            return new File(this.errorDir, this.csvInput.getFileName());
        }
        return new File(this.errorDir, this.getCurrentFile(this.csvInput.getFileName(), 1));
    }

    private String getCurrentFile(String fileName, int level) {
        String name = this.csvInput.getFileName().replace(".csv", "").concat("_" + level).concat(".csv");
        if (!this.filesName.contains(name)) {
            return name;
        }
        return this.getCurrentFile(fileName, level++);
    }

    private void exportInput() {
        if (!this.inputExported) {
            try {
                this.computeBindings();
            }
            catch (IOException ex) {
                this.LOG.error("Error while accessing file {}", (Object)this.configFile.getName());
            }
            finally {
                this.inputExported = true;
            }
        }
    }

    private void computeBindings() throws IOException {
        List lines = Lists.newArrayList();
        StringBuilder sb = new StringBuilder();
        XStream xStream = XStreamUtils.createXStream();
        xStream.processAnnotations(CSVConfig.class);
        String originalFileName = this.csvInput.getFileName();
        if (this.configFile == null) {
            this.createConfigFile();
            for (DataAdapter adapter : this.csvConfig.getAdapters()) {
                sb.append(xStream.toXML((Object)adapter));
            }
        } else {
            lines = Files.readLines((File)this.configFile, (Charset)Charsets.UTF_8);
            for (int i = 0; i < lines.size() - 1; ++i) {
                if (i == 0 || i == 1 || i == lines.size() - 1) continue;
                String line = (String)lines.get(i);
                sb.append(line);
                if (Strings.isNullOrEmpty((String)line)) continue;
                sb.append("\n");
            }
        }
        this.csvInput.setFileName(this.currentFile.getName());
        sb.append(xStream.toXML((Object)this.csvInput));
        this.csvInput.setFileName(originalFileName);
        Files.asCharSink((File)this.configFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)this.prepareXML(sb.toString()));
    }

    private void createConfigFile() throws IOException {
        this.configFile = new File(this.errorDir, DEFAULT_CONFIG_NAME);
        Files.createParentDirs((File)this.configFile);
    }

    private String prepareXML(String xml) {
        StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='UTF-8'?>\n");
        sb.append("<csv-inputs").append(" xmlns='").append("http://axelor.com/xml/ns/data-import").append("'").append(" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'").append(" xsi:schemaLocation='").append("http://axelor.com/xml/ns/data-import").append(" ").append("http://axelor.com/xml/ns/data-import/" + REMOTE_SCHEMA).append("'").append(">\n\n").append(xml).append("\n\n</csv-inputs>");
        return sb.toString();
    }
}

