/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.data.xml;

import com.axelor.data.ImportException;
import com.axelor.data.ImportTask;
import com.axelor.data.Importer;
import com.axelor.data.Listener;
import com.axelor.data.XStreamUtils;
import com.axelor.data.adapter.DataAdapter;
import com.axelor.data.xml.ElementConverter;
import com.axelor.data.xml.XMLBind;
import com.axelor.data.xml.XMLBinder;
import com.axelor.data.xml.XMLConfig;
import com.axelor.data.xml.XMLInput;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.internal.DBHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.WstxDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.xml.stream.XMLInputFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLImporter
implements Importer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private File dataDir;
    private XMLConfig config;
    private Map<String, Object> context;
    private List<Listener> listeners = Lists.newArrayList();
    private boolean canClear = true;

    @Inject
    public XMLImporter(@Named(value="axelor.data.config") String configFile, @Named(value="axelor.data.dir") String dataDir) {
        Preconditions.checkNotNull((Object)configFile);
        File file = new File(configFile);
        Preconditions.checkArgument((boolean)file.isFile(), (Object)("No such file: " + configFile));
        if (dataDir != null) {
            File _data = new File(dataDir);
            Preconditions.checkArgument((boolean)_data.isDirectory());
            this.dataDir = _data;
        }
        this.config = XMLConfig.parse(file);
    }

    public XMLImporter(String configFile) {
        this(configFile, null);
    }

    @Override
    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    private List<File> getFiles(String ... names) {
        ArrayList all = Lists.newArrayList();
        for (String name : names) {
            all.add(this.dataDir != null ? new File(this.dataDir, name) : new File(name));
        }
        return all;
    }

    @Override
    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void clearListener() {
        this.listeners.clear();
    }

    public void setCanClear(boolean canClear) {
        this.canClear = canClear;
    }

    @Override
    public void run() {
        for (XMLInput input : this.config.getInputs()) {
            String fileName = input.getFileName();
            List<File> files = this.getFiles(fileName);
            for (File file : files) {
                try {
                    this.process(input, file);
                }
                catch (Exception e) {
                    this.log.error("Error while importing {}.", (Object)file, (Object)e);
                }
            }
        }
    }

    @Override
    public void run(ImportTask task) {
        try {
            if (task.readers.isEmpty()) {
                task.configure();
            }
            block7: for (XMLInput input : this.config.getInputs()) {
                for (Reader reader : task.readers.get((Object)input.getFileName())) {
                    try {
                        this.process(input, reader);
                    }
                    catch (ImportException e) {
                        if (task.handle(e)) continue;
                        continue block7;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            task.readers.clear();
        }
    }

    private void process(XMLInput input, File file) throws ImportException {
        try {
            this.log.info("Importing: {}", (Object)file.getName());
            this.process(input, new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));
        }
        catch (IOException e) {
            throw new ImportException(e);
        }
    }

    private void process(XMLInput input, Reader reader) throws ImportException {
        boolean started;
        final int batchSize = DBHelper.getJdbcBatchSize();
        WstxDriver driver = new WstxDriver(){

            protected XMLInputFactory createInputFactory() {
                XMLInputFactory factory = super.createInputFactory();
                factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
                return factory;
            }
        };
        XStream stream = new XStream((HierarchicalStreamDriver)driver){
            private String root;
            {
                this.root = null;
            }

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new MapperWrapper((Mapper)next){

                    public Class realClass(String elementName) {
                        if (root == null) {
                            root = elementName;
                            return Document.class;
                        }
                        return Element.class;
                    }
                };
            }
        };
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (this.context != null) {
            context.putAll(this.context);
        }
        if (this.dataDir != null) {
            context.put("__path__", this.dataDir.toPath());
        }
        XMLBinder binder = new XMLBinder(input, context){
            int count;
            int total;
            {
                super(input, context);
                this.count = 0;
                this.total = 0;
            }

            @Override
            protected void handle(Object bean, XMLBind binding, Map<String, Object> ctx) {
                block8: {
                    if (bean == null) {
                        return;
                    }
                    try {
                        bean = binding.call(bean, ctx);
                        if (bean == null) break block8;
                        bean = JPA.manage((Model)bean);
                        ++this.count;
                        for (Listener listener : XMLImporter.this.listeners) {
                            listener.imported((Model)bean);
                        }
                    }
                    catch (Exception e) {
                        XMLImporter.this.log.error("Unable to import object {}.", bean);
                        XMLImporter.this.log.error("With binding {}.", (Object)binding);
                        XMLImporter.this.log.error("With exception:", (Throwable)e);
                        if (JPA.em().getTransaction().getRollbackOnly()) {
                            JPA.em().getTransaction().rollback();
                        }
                        if (!JPA.em().getTransaction().isActive()) {
                            JPA.em().getTransaction().begin();
                        }
                        for (Listener listener : XMLImporter.this.listeners) {
                            listener.handle((Model)bean, e);
                        }
                    }
                }
                if (++this.total % batchSize == 0) {
                    JPA.flush();
                    JPA.clear();
                }
            }

            @Override
            protected void finish() {
                for (Listener listener : XMLImporter.this.listeners) {
                    listener.imported(this.total, this.count);
                }
            }
        };
        for (DataAdapter adapter : defaultAdapters) {
            binder.registerAdapter(adapter);
        }
        for (DataAdapter adapter : this.config.getAdapters()) {
            binder.registerAdapter(adapter);
        }
        for (DataAdapter adapter : input.getAdapters()) {
            binder.registerAdapter(adapter);
        }
        XStreamUtils.setupSecurity(stream);
        stream.setMode(1001);
        stream.registerConverter((Converter)new ElementConverter(binder));
        EntityManager em = JPA.em();
        EntityTransaction txn = em.getTransaction();
        boolean bl = started = !txn.isActive();
        if (this.canClear) {
            em.setFlushMode(FlushModeType.COMMIT);
        }
        if (started) {
            txn.begin();
        }
        try {
            stream.fromXML(reader);
            binder.finish();
            if (txn.isActive() && started) {
                txn.commit();
                if (this.canClear) {
                    em.clear();
                }
            }
        }
        catch (Exception e) {
            if (txn.isActive() && started) {
                txn.rollback();
            }
            throw new ImportException(e);
        }
    }
}

