/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db;

import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.db.mapper.PropertyType;
import com.axelor.rpc.ContextEntity;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.hibernate.proxy.HibernateProxy;

public final class EntityHelper {
    private static boolean isSimple(Property field) {
        return !field.isTransient() && !field.isPrimary() && !field.isVersion() && !field.isCollection() && !field.isReference() && !field.isVirtual() && !field.isImage() && field.getType() != PropertyType.TEXT && field.getType() != PropertyType.BINARY;
    }

    public static <T extends Model> String toString(T entity) {
        if (entity == null) {
            return null;
        }
        Mapper mapper = Mapper.of(entity.getClass());
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(entity);
        helper.add("id", (Object)entity.getId());
        for (Property field : mapper.getProperties()) {
            if (!EntityHelper.isSimple(field) || field.isPassword()) continue;
            helper.add(field.getName(), field.get(entity));
        }
        return helper.omitNullValues().toString();
    }

    public static <T extends Model> int hashCode(T entity) {
        if (entity == null) {
            return 31;
        }
        Mapper mapper = Mapper.of(entity.getClass());
        ArrayList<Object> values = new ArrayList<Object>();
        for (Property p : mapper.getProperties()) {
            if (!EntityHelper.isSimple(p) || !p.isHashKey() && !p.isUnique()) continue;
            values.add(p.get(entity));
        }
        return values.isEmpty() ? 31 : Arrays.hashCode(values.toArray());
    }

    public static <T extends Model> boolean equals(T entity, Object other) {
        if (entity == other) {
            return true;
        }
        if (entity == null || other == null) {
            return false;
        }
        if (!entity.getClass().isInstance(other)) {
            return false;
        }
        Model that = (Model)other;
        if (entity.getId() != null || that.getId() != null) {
            return Objects.equals(entity.getId(), that.getId());
        }
        Mapper mapper = Mapper.of(entity.getClass());
        boolean hasHashKeys = false;
        for (Property field : mapper.getProperties()) {
            if (!field.isHashKey()) continue;
            hasHashKeys = true;
            if (Objects.equals(field.get(entity), field.get(other))) continue;
            return false;
        }
        return hasHashKeys;
    }

    public static <T> Class<T> getEntityClass(T entity) {
        Preconditions.checkNotNull(entity);
        if (entity instanceof HibernateProxy) {
            return ((HibernateProxy)entity).getHibernateLazyInitializer().getPersistentClass();
        }
        Class<?> klass = entity.getClass();
        while (ContextEntity.class.isAssignableFrom(klass)) {
            klass = klass.getSuperclass();
        }
        return klass;
    }

    public static <T> T getEntity(T entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof HibernateProxy) {
            return (T)((HibernateProxy)entity).getHibernateLazyInitializer().getImplementation();
        }
        if (entity instanceof ContextEntity) {
            return (T)((ContextEntity)entity).getContextEntity();
        }
        return entity;
    }

    public static <T> boolean isUninitialized(T entity) {
        return entity instanceof HibernateProxy && ((HibernateProxy)entity).getHibernateLazyInitializer().isUninitialized();
    }
}

