/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db;

import com.axelor.app.AppSettings;
import com.axelor.auth.AuditInterceptor;
import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.db.JpaScanner;
import com.axelor.db.hibernate.dialect.CustomDialectResolver;
import com.axelor.db.hibernate.naming.ImplicitNamingStrategyImpl;
import com.axelor.db.hibernate.naming.PhysicalNamingStrategyImpl;
import com.axelor.db.internal.DBHelper;
import com.axelor.db.search.SearchMappingFactory;
import com.axelor.db.search.SearchModule;
import com.axelor.db.tenants.TenantConnectionProvider;
import com.axelor.db.tenants.TenantModule;
import com.axelor.db.tenants.TenantResolver;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.persist.PersistService;
import com.google.inject.persist.jpa.JpaPersistModule;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.cache.ehcache.EhCacheRegionFactory;
import org.hibernate.cache.jcache.JCacheRegionFactory;
import org.hibernate.hikaricp.internal.HikariCPConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaModule
extends AbstractModule {
    private static Logger log = LoggerFactory.getLogger(JpaModule.class);
    private String jpaUnit;
    private boolean autoscan;
    private boolean autostart;

    public JpaModule(String jpaUnit, boolean autoscan, boolean autostart) {
        this.jpaUnit = jpaUnit;
        this.autoscan = autoscan;
        this.autostart = autostart;
    }

    public JpaModule(String jpaUnit) {
        this(jpaUnit, true, true);
    }

    public JpaModule scan(String pkg) {
        JpaScanner.include(pkg);
        return this;
    }

    protected void configure() {
        log.debug("Configuring database...");
        AppSettings settings = AppSettings.get();
        Properties properties = new Properties();
        if (this.autoscan) {
            properties.put("hibernate.archive.scanner", JpaScanner.class.getName());
        }
        properties.put("hibernate.session_factory.interceptor", AuditInterceptor.class.getName());
        properties.put("hibernate.id.new_generator_mappings", "true");
        properties.put("hibernate.implicit_naming_strategy", ImplicitNamingStrategyImpl.class.getName());
        properties.put("hibernate.physical_naming_strategy", PhysicalNamingStrategyImpl.class.getName());
        properties.put("hibernate.dialect_resolvers", CustomDialectResolver.class.getName());
        properties.put("hibernate.connection.autocommit", "false");
        properties.put("hibernate.max_fetch_depth", "3");
        if (!DBHelper.isDataSourceUsed()) {
            properties.put("hibernate.connection.provider_class", HikariCPConnectionProvider.class.getName());
            properties.put("hibernate.connection.provider_disables_autocommit", "true");
            properties.put("hibernate.hikari.minimumIdle", "5");
            properties.put("hibernate.hikari.maximumPoolSize", "20");
            properties.put("hibernate.hikari.idleTimeout", "300000");
        }
        settings.getProperties().stringPropertyNames().stream().filter(n -> n.startsWith("hibernate.")).forEach(n -> properties.put(n, settings.get((String)n)));
        this.configureCache(settings, properties);
        this.configureMultiTenancy(settings, properties);
        this.configureSearch(settings, properties);
        try {
            this.configureConnection(settings, properties);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.install((Module)new SearchModule());
        this.install((Module)new TenantModule());
        this.install((Module)new JpaPersistModule(this.jpaUnit).properties((Map)properties));
        if (this.autostart) {
            this.bind(Initializer.class).asEagerSingleton();
        }
        this.bind(JPA.class).asEagerSingleton();
    }

    private void configureConnection(AppSettings settings, Properties properties) {
        if (DBHelper.isDataSourceUsed()) {
            properties.put("hibernate.connection.datasource", DBHelper.getDataSourceName());
            return;
        }
        HashMap<String, String> keys = new HashMap<String, String>();
        String unit = this.jpaUnit.replaceAll("(PU|Unit)$", "").replaceAll("^persistence$", "default");
        keys.put("db.%s.ddl", "hibernate.hbm2ddl.auto");
        keys.put("db.%s.driver", "javax.persistence.jdbc.driver");
        keys.put("db.%s.url", "javax.persistence.jdbc.url");
        keys.put("db.%s.user", "javax.persistence.jdbc.user");
        keys.put("db.%s.password", "javax.persistence.jdbc.password");
        for (String key : keys.keySet()) {
            String name = (String)keys.get(key);
            String value = settings.get(String.format(key, unit));
            if (StringUtils.isBlank((CharSequence)value)) continue;
            properties.put(name, value.trim());
        }
    }

    private void configureCache(AppSettings settings, Properties properties) {
        if (!DBHelper.isCacheEnabled()) {
            return;
        }
        properties.put("hibernate.cache.use_second_level_cache", "true");
        properties.put("hibernate.cache.use_query_cache", "true");
        String jcacheProvider = settings.get("hibernate.javax.cache.provider");
        String jcacheConfig = settings.get("hibernate.javax.cache.uri");
        if (jcacheProvider != null) {
            properties.put("hibernate.cache.region.factory_class", JCacheRegionFactory.class.getName());
            properties.put("hibernate.javax.cache.provider", jcacheProvider);
            properties.put("hibernate.javax.cache.uri", jcacheConfig);
        } else {
            properties.put("hibernate.cache.region.factory_class", EhCacheRegionFactory.class.getName());
        }
    }

    private void configureMultiTenancy(AppSettings settings, Properties properties) {
        if (TenantModule.isEnabled()) {
            properties.put("hibernate.multiTenancy", MultiTenancyStrategy.DATABASE.name());
            properties.put("hibernate.multi_tenant_connection_provider", TenantConnectionProvider.class.getName());
            properties.put("hibernate.tenant_identifier_resolver", TenantResolver.class.getName());
        }
    }

    private void configureSearch(AppSettings settings, Properties properties) {
        if (!SearchModule.isEnabled()) {
            properties.put("hibernate.search.autoregister_listeners", "false");
            properties.remove("hibernate.search.default.directory_provider");
        } else {
            if (properties.getProperty("hibernate.search.default.directory_provider") == null) {
                properties.setProperty("hibernate.search.default.directory_provider", "filesystem");
            }
            if (properties.getProperty("hibernate.search.default.indexBase") == null) {
                properties.setProperty("hibernate.search.default.indexBase", settings.getPath("hibernate.search.default.indexBase", "{user.home}/.axelor/indexes"));
            }
            properties.put("hibernate.search.model_mapping", SearchMappingFactory.class.getName());
        }
    }

    static {
        JpaScanner.exclude("com.axelor.test.db");
        JpaScanner.exclude("com.axelor.web.db");
    }

    public static class Initializer {
        @Inject
        Initializer(PersistService service) {
            log.debug("Starting database service...");
            service.start();
        }
    }
}

