/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db;

import com.axelor.db.EntityHelper;
import com.axelor.db.JPA;
import com.axelor.db.JpaScanner;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.db.Repository;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.db.mapper.PropertyType;
import com.axelor.inject.Beans;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JpaRepository<T extends Model>
implements Repository<T> {
    protected Class<T> modelClass;

    protected JpaRepository(Class<T> modelClass) {
        this.modelClass = modelClass;
    }

    @Override
    public List<Property> fields() {
        Property[] fields = JPA.fields(this.modelClass);
        if (fields == null) {
            return null;
        }
        return Arrays.asList(fields);
    }

    @Override
    public Query<T> all() {
        return JPA.all(this.modelClass);
    }

    public <U extends T> Query<U> all(Class<U> type) {
        return JPA.all(type);
    }

    @Override
    public T create(Map<String, Object> values) {
        return (T)((Model)Mapper.toBean(this.modelClass, values));
    }

    @Override
    public T copy(T entity, boolean deep) {
        return JPA.copy(entity, deep);
    }

    @Override
    public T find(Long id) {
        return JPA.find(this.modelClass, id);
    }

    @Override
    public T save(T entity) {
        return JPA.save(entity);
    }

    public void persist(T entity) {
        JPA.persist(entity);
    }

    public T merge(T entity) {
        return JPA.merge(entity);
    }

    @Override
    public void remove(T entity) {
        this.detachChildren(entity);
        JPA.remove(entity);
    }

    private void detachChildren(T entity) {
        if (!JPA.em().contains(entity)) {
            return;
        }
        Mapper mapper = Mapper.of(EntityHelper.getEntityClass(entity));
        for (Property property : mapper.getProperties()) {
            Collection items;
            if (property.getType() != PropertyType.ONE_TO_MANY || !property.isOrphan()) continue;
            Property mappedBy = Mapper.of(property.getTarget()).getProperty(property.getMappedBy());
            if (mappedBy != null && mappedBy.isRequired() || (items = (Collection)property.get(entity)) == null || items.size() == 0) continue;
            for (Model item : items) {
                property.setAssociation(item, null);
            }
        }
    }

    @Override
    public void refresh(T entity) {
        JPA.refresh(entity);
    }

    @Override
    public void flush() {
        JPA.flush();
    }

    @Override
    public Map<String, Object> validate(Map<String, Object> json, Map<String, Object> context) {
        return json;
    }

    @Override
    public Map<String, Object> populate(Map<String, Object> json, Map<String, Object> context) {
        return json;
    }

    public static <U extends Model> JpaRepository<U> of(Class<U> type) {
        Class<?> klass = JpaScanner.findRepository(type.getSimpleName() + "Repository");
        if (klass != null) {
            JpaRepository repo = (JpaRepository)Beans.get(klass);
            if (repo.modelClass.isAssignableFrom(type)) {
                return repo;
            }
        }
        return Beans.inject(new JpaRepository<U>(type));
    }
}

