/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db;

import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaSequence;
import com.axelor.meta.db.repo.MetaSequenceRepository;
import com.google.common.base.Strings;

public final class JpaSequence {
    private JpaSequence() {
    }

    private static MetaSequence find(String name) {
        MetaSequenceRepository repo = Beans.get(MetaSequenceRepository.class);
        MetaSequence sequence = repo.findByName(name);
        if (sequence == null) {
            throw new IllegalArgumentException("No such sequence: " + name);
        }
        return sequence;
    }

    public static String nextValue(String name) {
        MetaSequence sequence = JpaSequence.find(name);
        Long next = sequence.getNext();
        String prefix = sequence.getPrefix();
        String suffix = sequence.getSuffix();
        Integer padding = sequence.getPadding();
        String value = "" + next;
        if (padding > 0) {
            value = Strings.padStart((String)value, (int)padding, (char)'0');
        }
        if (!StringUtils.isBlank((CharSequence)prefix)) {
            value = prefix + value;
        }
        if (!StringUtils.isBlank((CharSequence)suffix)) {
            value = value + suffix;
        }
        sequence.setNext(next + (long)sequence.getIncrement().intValue());
        JPA.em().persist((Object)sequence);
        return value;
    }

    public static void nextValue(String name, long next) {
        MetaSequence sequence = JpaSequence.find(name);
        sequence.setNext(next);
        JPA.em().persist((Object)sequence);
    }
}

