/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.common.ObjectUtils;
import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.QueryBinder;
import com.axelor.db.hibernate.type.JsonFunction;
import com.axelor.db.internal.DBHelper;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.db.mapper.PropertyType;
import com.axelor.rpc.Resource;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.TypedQuery;
import org.hibernate.QueryException;

public class Query<T extends Model> {
    private Class<T> beanClass;
    private String filter;
    private Object[] params;
    private Map<String, Object> namedParams;
    private String orderBy;
    private List<String> orderNames;
    private JoinHelper joinHelper;
    private boolean cacheable;
    private boolean readOnly;
    private FlushModeType flushMode = FlushModeType.AUTO;
    private static final String NAME_PATTERN = "((?:[a-zA-Z_]\\w+)(?:(?:\\[\\])?\\.\\w+)*)";
    private static final Pattern PLACEHOLDER_PLAIN = Pattern.compile("(?<!\\?)\\?(?!(\\d+|\\?))");
    private static final Pattern PLACEHOLDER_INDEXED = Pattern.compile("\\?\\d+");

    public Query(Class<T> beanClass) {
        this.beanClass = beanClass;
        this.orderBy = "";
        this.orderNames = new ArrayList<String>();
        this.joinHelper = new JoinHelper(beanClass);
    }

    public static <T extends Model> Query<T> of(Class<T> klass) {
        return new Query<T>(klass);
    }

    protected EntityManager em() {
        return JPA.em();
    }

    public Query<T> filter(String filter, Object ... params) {
        if (this.filter != null) {
            throw new IllegalStateException("Query is already filtered.");
        }
        if (StringUtils.isBlank((CharSequence)filter)) {
            throw new IllegalArgumentException("filter string is required.");
        }
        if (PLACEHOLDER_PLAIN.matcher(filter).find() && PLACEHOLDER_INDEXED.matcher(filter).find()) {
            throw new IllegalArgumentException("JDBC and JPA-style positional parameters can't be mixed: " + filter);
        }
        int i = 1;
        Matcher matcher = PLACEHOLDER_PLAIN.matcher(filter);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "?" + i++);
        }
        matcher.appendTail(sb);
        this.filter = this.joinHelper.parse(sb.toString());
        this.params = params;
        return this;
    }

    public Query<T> filter(String filter) {
        Object[] params = new Object[]{};
        return this.filter(filter, params);
    }

    public Query<T> order(String spec) {
        this.orderBy = this.orderBy.length() > 0 ? this.orderBy + ", " : " ORDER BY ";
        String name = spec.trim();
        if (name.matches("(-)?\\s*(self\\.).*")) {
            throw new IllegalArgumentException("Query#order(String) called with 'self' prefixed argument: " + spec);
        }
        if (name.charAt(0) == '-') {
            name = this.joinHelper.joinFetchName(name.substring(1));
            this.orderBy = this.orderBy + name + " DESC";
        } else {
            name = this.joinHelper.joinFetchName(name);
            this.orderBy = this.orderBy + name;
        }
        this.orderNames.add(name);
        return this;
    }

    public Query<T> cacheable() {
        this.cacheable = true;
        return this;
    }

    public Query<T> readOnly() {
        this.readOnly = true;
        return this;
    }

    public Query<T> autoFlush(boolean auto) {
        this.flushMode = auto ? FlushModeType.AUTO : FlushModeType.COMMIT;
        return this;
    }

    public Stream<T> fetchStream() {
        return this.fetchStream(0, 0);
    }

    @Deprecated
    public Stream<T> fetchSteam() {
        return this.fetchStream();
    }

    public Stream<T> fetchStream(int limit) {
        return this.fetchStream(limit, 0);
    }

    @Deprecated
    public Stream<T> fetchSteam(int limit) {
        return this.fetchStream(limit);
    }

    public Stream<T> fetchStream(int limit, int offset) {
        org.hibernate.query.Query query = (org.hibernate.query.Query)this.fetchQuery(limit, offset);
        if (limit <= 0) {
            query.setFetchSize(DBHelper.getJdbcFetchSize());
        }
        return query.stream();
    }

    @Deprecated
    public Stream<T> fetchSteam(int limit, int offset) {
        return this.fetchStream(limit, offset);
    }

    public List<T> fetch() {
        return this.fetch(0, 0);
    }

    public List<T> fetch(int limit) {
        return this.fetch(limit, 0);
    }

    public List<T> fetch(int limit, int offset) {
        return this.fetchQuery(limit, offset).getResultList();
    }

    private TypedQuery<T> fetchQuery(int limit, int offset) {
        TypedQuery query = this.em().createQuery(this.selectQuery(), this.beanClass);
        query.setHint("hibernate.query.passDistinctThrough", (Object)false);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        QueryBinder binder = this.bind((javax.persistence.Query)query).opts(this.cacheable, this.flushMode);
        if (this.readOnly) {
            binder.setReadOnly();
        }
        return query;
    }

    public T fetchOne() {
        try {
            return (T)((Model)this.fetch(1).get(0));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public T fetchOne(int offset) {
        try {
            return (T)((Model)this.fetch(1, offset).get(0));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public long count() {
        TypedQuery query = this.em().createQuery(this.countQuery(), Long.class);
        query.setHint("hibernate.query.passDistinctThrough", (Object)false);
        this.bind((javax.persistence.Query)query).setCacheable(this.cacheable).setFlushMode(this.flushMode).setReadOnly();
        return (Long)query.getSingleResult();
    }

    public Selector select(String ... names) {
        return new Selector(names);
    }

    public int update(Map<String, Object> values) {
        return this.update(values, null);
    }

    public int update(String name, Object value) {
        return this.update(Collections.singletonMap(name, value));
    }

    public int update(Map<String, Object> values, User updatedBy) {
        if (ObjectUtils.isEmpty(values)) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> namedParams = new HashMap<String, Object>();
        ArrayList<String> where = new ArrayList<String>();
        if (this.namedParams != null) {
            namedParams.putAll(this.namedParams);
        }
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String name = entry.getKey().replaceFirst("^self\\.", "");
            Object value = entry.getValue();
            params.put(name, value);
            if (value == null) {
                where.add("self." + name + " IS NOT NULL");
                continue;
            }
            where.add("(self." + name + " IS NULL OR self." + name + " != :" + name + ")");
        }
        if (updatedBy != null && AuditableModel.class.isAssignableFrom(this.beanClass)) {
            params.put("updatedBy", updatedBy);
            params.put("updatedOn", LocalDateTime.now());
        }
        namedParams.putAll(params);
        boolean versioned = updatedBy != null;
        boolean notMySQL = !DBHelper.isMySQL();
        String whereClause = String.join((CharSequence)" OR ", where);
        String selectQuery = this.updateQuery().replaceFirst("SELECT self", "SELECT self.id");
        selectQuery = selectQuery.contains(" WHERE ") ? selectQuery.replaceFirst(" WHERE ", " WHERE (" + whereClause + ") AND (") + ")" : selectQuery + " WHERE " + whereClause;
        selectQuery = selectQuery.replaceAll("\\bself", "that");
        if (notMySQL) {
            return QueryBinder.of(this.em().createQuery(this.updateQuery(params, versioned, "self.id IN (" + selectQuery + ")"))).bind(namedParams, this.params).getQuery().executeUpdate();
        }
        String updateQuery = this.updateQuery(params, versioned, "self.id IN (:ids)");
        int count = 0;
        int limit = 1000;
        TypedQuery sq = this.em().createQuery(selectQuery, Long.class);
        javax.persistence.Query uq = this.em().createQuery(updateQuery);
        QueryBinder.of((javax.persistence.Query)sq).bind(namedParams, this.params);
        QueryBinder.of(uq).bind(namedParams, this.params);
        sq.setFirstResult(0);
        sq.setMaxResults(limit);
        List ids = sq.getResultList();
        while (!ids.isEmpty()) {
            uq.setParameter("ids", (Object)ids);
            count += uq.executeUpdate();
            ids = sq.getResultList();
        }
        return count;
    }

    public int update(String name, Object value, User updatedBy) {
        return this.update(Collections.singletonMap(name, value), updatedBy);
    }

    public int delete() {
        boolean notMySQL = !DBHelper.isMySQL();
        String selectQuery = this.updateQuery().replaceFirst("SELECT self", "SELECT self.id").replaceAll("\\bself", "that");
        if (notMySQL) {
            javax.persistence.Query q = this.em().createQuery(this.deleteQuery("self.id IN (" + selectQuery + ")"));
            this.bind(q);
            return q.executeUpdate();
        }
        TypedQuery sq = this.em().createQuery(selectQuery, Long.class);
        javax.persistence.Query dq = this.em().createQuery(this.deleteQuery("self.id IN (:ids)"));
        this.bind((javax.persistence.Query)sq);
        this.bind(dq);
        int count = 0;
        int limit = 1000;
        sq.setFirstResult(0);
        sq.setMaxResults(limit);
        List ids = sq.getResultList();
        while (!ids.isEmpty()) {
            dq.setParameter("ids", (Object)ids);
            count += dq.executeUpdate();
            ids = sq.getResultList();
        }
        return count;
    }

    public long remove() {
        return this.fetchStream().peek(JPA::remove).count();
    }

    protected String selectQuery(boolean update) {
        StringBuilder sb = new StringBuilder("SELECT self FROM ").append(this.beanClass.getSimpleName()).append(" self").append(this.joinHelper.toString(!update));
        if (this.filter != null && this.filter.trim().length() > 0) {
            sb.append(" WHERE ").append(this.filter);
        }
        if (update) {
            return sb.toString();
        }
        sb.append(this.orderBy);
        return this.joinHelper.fixSelect(sb.toString());
    }

    protected String selectQuery() {
        return this.selectQuery(false);
    }

    protected String updateQuery() {
        return this.selectQuery(true);
    }

    protected String countQuery() {
        StringBuilder sb = new StringBuilder("SELECT COUNT(self.id) FROM ").append(this.beanClass.getSimpleName()).append(" self").append(this.joinHelper.toString(false));
        if (this.filter != null && this.filter.trim().length() > 0) {
            sb.append(" WHERE ").append(this.filter);
        }
        return this.joinHelper.fixSelect(sb.toString());
    }

    protected String updateQuery(Map<String, Object> values, boolean versioned, String filter) {
        String items = values.keySet().stream().map(key -> String.format("self.%s = :%s", key, key)).collect(Collectors.joining(", "));
        StringBuilder sb = new StringBuilder("UPDATE ").append(versioned ? "VERSIONED " : "").append(this.beanClass.getSimpleName()).append(" self").append(" SET ").append(items);
        if (StringUtils.notBlank((CharSequence)filter)) {
            sb.append(" WHERE ").append(filter);
        }
        return sb.toString();
    }

    protected String deleteQuery(String filter) {
        StringBuilder sb = new StringBuilder("DELETE FROM ").append(this.beanClass.getSimpleName()).append(" self");
        if (StringUtils.notBlank((CharSequence)filter)) {
            sb.append(" WHERE ").append(filter);
        }
        return sb.toString();
    }

    protected QueryBinder bind(javax.persistence.Query query) {
        return QueryBinder.of(query).bind(this.namedParams, this.params);
    }

    public Query<T> bind(Map<String, Object> params) {
        if (this.namedParams == null) {
            this.namedParams = Maps.newHashMap();
        }
        if (params != null) {
            this.namedParams.putAll(params);
        }
        return this;
    }

    public Query<T> bind(String name, Object value) {
        HashMap params = Maps.newHashMap();
        params.put(name, value);
        return this.bind(params);
    }

    public String toString() {
        return this.selectQuery();
    }

    private static class JoinHelper {
        private Class<?> beanClass;
        private Map<String, String> joins = Maps.newLinkedHashMap();
        private Set<String> fetches = new HashSet<String>();
        private boolean hasCollection;
        private static final Pattern selectPattern = Pattern.compile("^SELECT\\s+(COUNT\\s*\\()?", 2);
        private static final Pattern pathPattern = Pattern.compile("self\\.((?:[a-zA-Z_]\\w+)(?:(?:\\[\\])?\\.\\w+)*)");

        public JoinHelper(Class<?> beanClass) {
            this.beanClass = beanClass;
        }

        private String parse(String filter) {
            String result = "";
            Matcher matcher = pathPattern.matcher(filter);
            int last = 0;
            while (matcher.find()) {
                MatchResult matchResult = matcher.toMatchResult();
                String alias = this.joinName(matchResult.group(1));
                if (alias == null) {
                    alias = "self." + matchResult.group(1);
                }
                result = result + filter.substring(last, matchResult.start()) + alias;
                last = matchResult.end();
            }
            if (last < filter.length()) {
                result = result + filter.substring(last);
            }
            return result;
        }

        protected String joinName(String name, boolean fetch) {
            Mapper mapper = Mapper.of(this.beanClass);
            String[] path = name.split("\\.");
            String prefix = null;
            String variable = name;
            if (path.length > 1) {
                variable = path[path.length - 1];
                String joinOn = null;
                Mapper currentMapper = mapper;
                for (int i = 0; i < path.length - 1; ++i) {
                    String item = path[i].replace("[]", "");
                    Property property = currentMapper.getProperty(item);
                    if (property == null) {
                        throw new QueryException("could not resolve property: " + item + " of: " + currentMapper.getBeanClass().getName());
                    }
                    if (property.isJson()) {
                        return JsonFunction.fromPath(name).toString();
                    }
                    if (prefix == null) {
                        joinOn = "self." + item;
                        prefix = "_" + item;
                        if (this.fetches.isEmpty() && property.isCollection()) {
                            this.fetches.add(joinOn);
                        }
                    } else {
                        joinOn = prefix + "." + item;
                        prefix = prefix + "_" + item;
                    }
                    if (!this.joins.containsKey(joinOn)) {
                        this.joins.put(joinOn, prefix);
                    }
                    if (fetch) {
                        this.fetches.add(joinOn);
                    }
                    if (property.getTarget() != null) {
                        currentMapper = Mapper.of(property.getTarget());
                        if (property.isCollection()) {
                            this.hasCollection = true;
                        }
                    }
                    if (i != path.length - 2) continue;
                    property = currentMapper.getProperty(variable);
                    if (property == null) {
                        throw new IllegalArgumentException(String.format("No such field '%s' in object '%s'", variable, currentMapper.getBeanClass().getName()));
                    }
                    if (!property.isReference()) continue;
                    joinOn = prefix + "." + variable;
                    prefix = prefix + "_" + variable;
                    this.joins.put(joinOn, prefix);
                    if (fetch) {
                        this.fetches.add(joinOn);
                    }
                    return prefix;
                }
            } else {
                Property property = mapper.getProperty(name);
                if (property == null) {
                    throw new IllegalArgumentException(String.format("No such field '%s' in object '%s'", variable, this.beanClass.getName()));
                }
                if (property.isCollection()) {
                    return null;
                }
                if (property.getTarget() != null) {
                    prefix = "_" + name;
                    String joinOn = "self." + name;
                    this.joins.put(joinOn, prefix);
                    if (fetch) {
                        this.fetches.add(joinOn);
                    }
                    return prefix;
                }
            }
            if (prefix == null) {
                prefix = "self";
            }
            return prefix + "." + variable;
        }

        public String joinName(String name) {
            return this.joinName(name, false);
        }

        public String joinFetchName(String name) {
            return this.joinName(name, true);
        }

        public String fixSelect(String query) {
            return this.hasCollection ? selectPattern.matcher(query).replaceFirst("$0DISTINCT ") : query;
        }

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean fetch) {
            if (this.joins.isEmpty()) {
                return "";
            }
            ArrayList<String> joinItems = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this.joins.entrySet()) {
                String fetchString = fetch && this.fetches.contains(entry.getKey()) ? " FETCH" : "";
                joinItems.add(String.format("LEFT JOIN%s %s %s", fetchString, entry.getKey(), entry.getValue()));
            }
            return " " + joinItems.stream().collect(Collectors.joining(" "));
        }
    }

    public class Selector {
        private List<String> names = Lists.newArrayList((Object[])new String[]{"id", "version"});
        private List<String> collections = Lists.newArrayList();
        private String query;
        private Mapper mapper = Mapper.of(Query.access$200(Query.this));

        private Selector(String ... names) {
            ArrayList selects = Lists.newArrayList();
            selects.add("self.id");
            selects.add("self.version");
            for (String name : names) {
                JsonFunction func;
                Property json;
                Property property = this.getProperty(name);
                if (property != null && property.getType() != PropertyType.BINARY && !property.isTransient()) {
                    String alias = Query.this.joinHelper.joinName(name);
                    if (alias != null) {
                        selects.add(alias);
                        this.names.add(name);
                    } else {
                        this.collections.add(name);
                    }
                    if (!property.isReference() || property.getTargetName() == null) continue;
                    this.names.add(name + ".id");
                    this.names.add(name + ".version");
                    this.names.add(name + "." + property.getTargetName());
                    selects.add(Query.this.joinHelper.joinName(name + ".id"));
                    selects.add(Query.this.joinHelper.joinName(name + ".version"));
                    selects.add(Query.this.joinHelper.joinName(name + "." + property.getTargetName()));
                    continue;
                }
                if (name.indexOf(46) <= -1 || (json = this.mapper.getProperty((func = JsonFunction.fromPath(name)).getField())) == null || !json.isJson()) continue;
                this.names.add(func.getField() + "." + func.getAttribute());
                selects.add(func.toString());
            }
            if (Query.this.joinHelper.hasCollection) {
                Query.this.orderNames.stream().filter(n -> !selects.contains(n)).forEach(selects::add);
            }
            StringBuilder sb = new StringBuilder("SELECT").append(" new List(" + Joiner.on((String)", ").join((Iterable)selects) + ")").append(" FROM ").append(Query.this.beanClass.getSimpleName()).append(" self").append(Query.this.joinHelper.toString(false));
            if (Query.this.filter != null && Query.this.filter.trim().length() > 0) {
                sb.append(" WHERE ").append(Query.this.filter);
            }
            sb.append(Query.this.orderBy);
            this.query = Query.this.joinHelper.fixSelect(sb.toString());
        }

        private Property getProperty(String field) {
            if (field == null || "".equals(field.trim())) {
                return null;
            }
            Mapper mapper = this.mapper;
            Property property = null;
            Iterator names = Splitter.on((String)".").split((CharSequence)field).iterator();
            while (names.hasNext()) {
                property = mapper.getProperty((String)names.next());
                if (property == null) {
                    return null;
                }
                if (!names.hasNext()) continue;
                if (property.getTarget() == null) {
                    return null;
                }
                mapper = Mapper.of(property.getTarget());
            }
            return property;
        }

        public List<List> values(int limit, int offset) {
            javax.persistence.Query q = Query.this.em().createQuery(this.query);
            if (limit > 0) {
                q.setMaxResults(limit);
            }
            if (offset > 0) {
                q.setFirstResult(offset);
            }
            QueryBinder binder = Query.this.bind(q).opts(Query.this.cacheable, Query.this.flushMode);
            if (Query.this.readOnly) {
                binder.setReadOnly();
            }
            return q.getResultList();
        }

        public List<Map> fetch(int limit, int offset) {
            List<List> data = this.values(limit, offset);
            ArrayList result = Lists.newArrayList();
            for (List items : data) {
                HashMap map = Maps.newHashMap();
                for (int i = 0; i < this.names.size(); ++i) {
                    Object value = items.get(i);
                    String name = this.names.get(i);
                    Property property = this.getProperty(name);
                    if (property != null && property.isReference() && property.getTargetName() != null) {
                        value = this.getReferenceValue(items, i);
                        i += 3;
                    } else if (value instanceof Model) {
                        value = Resource.toMapCompact(value);
                    }
                    map.put(name, value);
                }
                if (this.collections.size() > 0) {
                    map.putAll(this.fetchCollections(items.get(0)));
                }
                result.add(map);
            }
            return result;
        }

        private Object getReferenceValue(List<?> items, int at) {
            if (items.get(at) == null) {
                return null;
            }
            HashMap value = Maps.newHashMap();
            String name = this.names.get(at);
            String nameField = this.names.get(at + 3).replace(name + ".", "");
            value.put("id", items.get(at + 1));
            value.put("$version", items.get(at + 2));
            value.put(nameField, items.get(at + 3));
            return value;
        }

        private Map<String, List> fetchCollections(Object id) {
            HashMap result = Maps.newHashMap();
            Object self = JPA.em().find(Query.this.beanClass, id);
            for (String name : this.collections) {
                Collection items = (Collection)this.mapper.get(self, name);
                if (items == null) continue;
                ArrayList all = Lists.newArrayList();
                for (Model obj : items) {
                    all.add(Resource.toMapCompact(obj));
                }
                result.put(name, all);
            }
            return result;
        }

        public String toString() {
            return this.query;
        }
    }
}

