/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db;

import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.mapper.Adapter;
import com.axelor.rpc.ContextEntity;
import com.axelor.script.ScriptBindings;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.FlushModeType;
import javax.persistence.Parameter;
import javax.persistence.Query;

public class QueryBinder {
    private final Query query;

    private QueryBinder(Query query) {
        this.query = query;
    }

    public static QueryBinder of(Query query) {
        return new QueryBinder(query);
    }

    public QueryBinder setCacheable() {
        return this.setCacheable(true);
    }

    public QueryBinder setCacheable(boolean cacheable) {
        this.query.setHint("org.hibernate.cacheable", (Object)cacheable);
        return this;
    }

    public QueryBinder setReadOnly() {
        return this.setReadOnly(true);
    }

    public QueryBinder setReadOnly(boolean readOnly) {
        this.query.setHint("org.hibernate.readOnly", (Object)readOnly);
        return this;
    }

    public QueryBinder setFlushMode(FlushModeType mode) {
        this.query.setFlushMode(mode);
        return this;
    }

    public QueryBinder opts(boolean cacheable, FlushModeType type) {
        this.setCacheable(cacheable);
        if (type != null) {
            this.setFlushMode(type);
        }
        return this;
    }

    public QueryBinder bind(Map<String, Object> namedParams, Object ... params) {
        ScriptBindings bindings = null;
        if (namedParams instanceof ScriptBindings) {
            bindings = (ScriptBindings)namedParams;
        } else {
            HashMap variables = Maps.newHashMap();
            if (namedParams != null) {
                variables.putAll(namedParams);
            }
            bindings = new ScriptBindings(variables);
        }
        if (namedParams != null) {
            for (Parameter p : this.query.getParameters()) {
                if (p.getName() == null || Ints.tryParse((String)p.getName()) != null) continue;
                this.bind(p.getName(), bindings.get(p.getName()));
            }
        }
        if (params == null) {
            return this;
        }
        int offset = 0;
        try {
            this.query.getParameter(0);
        }
        catch (Exception e) {
            offset = 1;
        }
        for (int i = 0; i < params.length; ++i) {
            Parameter param;
            Object value = params[i];
            if (value instanceof ContextEntity) {
                value = ((ContextEntity)value).getContextId();
            } else if (value instanceof Model) {
                value = ((Model)value).getId();
            } else if (value instanceof String && !StringUtils.isBlank((CharSequence)((String)value)) && bindings.containsKey(value)) {
                value = bindings.get(value);
            }
            try {
                param = this.query.getParameter(i + offset);
            }
            catch (Exception e) {
                continue;
            }
            try {
                this.query.setParameter(i + offset, value);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.query.setParameter(i + offset, this.adapt(value, param));
            }
        }
        return this;
    }

    public QueryBinder bind(String name, Object value) {
        Parameter parameter = null;
        try {
            parameter = this.query.getParameter(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (parameter == null) {
            return this;
        }
        if (value instanceof ContextEntity) {
            value = ((ContextEntity)value).getContextId();
        } else if (value instanceof Model) {
            value = ((Model)value).getId();
        } else if (value == null || value instanceof String && "".equals(((String)value).trim())) {
            value = this.adapt(value, parameter);
        }
        try {
            this.query.setParameter(name, value);
        }
        catch (IllegalArgumentException e) {
            this.query.setParameter(name, this.adapt(value, parameter));
        }
        return this;
    }

    public Query getQuery() {
        return this.query;
    }

    private Object adapt(Object value, Parameter<?> param) {
        Model bean;
        Class type = param.getParameterType();
        if (type == null) {
            return value;
        }
        if ((value = Adapter.adapt(value, type, type, null)) instanceof Number && Model.class.isAssignableFrom(type)) {
            value = JPA.em().find(type, value);
        } else if (value instanceof Model && type.isInstance(value) && (bean = (Model)value).getId() != null) {
            value = JPA.find(bean.getClass(), bean.getId());
        }
        return value;
    }
}

