/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.converters;

import com.axelor.app.AppSettings;
import com.axelor.common.StringUtils;
import com.axelor.common.crypto.Encryptor;
import javax.persistence.AttributeConverter;

public abstract class AbstractEncryptedConverter<T, R>
implements AttributeConverter<T, R> {
    private static final String ENCRYPTION_ALGORITHM = AppSettings.get().get("encryption.algorithm");
    private static final String ENCRYPTION_PASSWORD = AppSettings.get().get("encryption.password");
    private static final String OLD_ENCRYPTION_ALGORITHM = AppSettings.get().get("encryption.algorithm.old");
    private static final String OLD_ENCRYPTION_PASSWORD = AppSettings.get().get("encryption.password.old");
    private Encryptor<T, R> encryptor;
    private Encryptor<T, R> oldEncryptor;

    protected abstract Encryptor<T, R> getEncryptor(String var1, String var2);

    protected final Encryptor<T, R> encryptor() {
        if (this.encryptor == null && StringUtils.notBlank((CharSequence)ENCRYPTION_PASSWORD)) {
            this.encryptor = this.getEncryptor(ENCRYPTION_ALGORITHM, ENCRYPTION_PASSWORD);
        }
        return this.encryptor;
    }

    protected final Encryptor<T, R> oldEncryptor() {
        if (this.oldEncryptor == null && StringUtils.notBlank((CharSequence)OLD_ENCRYPTION_PASSWORD)) {
            this.oldEncryptor = this.getEncryptor(OLD_ENCRYPTION_ALGORITHM, OLD_ENCRYPTION_PASSWORD);
        }
        return this.oldEncryptor;
    }

    protected boolean isMigrating() {
        return "true".equalsIgnoreCase(System.getProperty("database.encrypt.migrate"));
    }

    public R convertToDatabaseColumn(T attribute) {
        Encryptor<T, R> e = this.encryptor();
        return (R)(e == null ? attribute : e.encrypt(attribute));
    }

    public T convertToEntityAttribute(R dbData) {
        Encryptor<T, R> e = this.isMigrating() ? this.oldEncryptor() : this.encryptor();
        return (T)(e == null ? dbData : e.decrypt(dbData));
    }
}

