/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.hibernate.dialect;

import com.axelor.db.hibernate.dialect.HSQLDialect;
import com.axelor.db.hibernate.dialect.MySQLDialect;
import com.axelor.db.hibernate.dialect.OracleDialect;
import com.axelor.db.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDialectResolver
extends StandardDialectResolver {
    private static final long serialVersionUID = 8211296180497513187L;
    private static final Logger log = LoggerFactory.getLogger(CustomDialectResolver.class);
    public static final CustomDialectResolver INSTANCE = new CustomDialectResolver();

    public Dialect resolveDialect(DialectResolutionInfo info) {
        String databaseName = info.getDatabaseName();
        int majorVersion = info.getDatabaseMajorVersion();
        int minorVersion = info.getDatabaseMinorVersion();
        if ("HSQL Database Engine".equals(databaseName)) {
            return new HSQLDialect();
        }
        if ("PostgreSQL".equals(databaseName)) {
            if (majorVersion >= 9 && minorVersion >= 4 || majorVersion >= 10) {
                return new PostgreSQLDialect();
            }
            log.error("PostgreSQL 9.4 or later is required.");
        }
        if ("Oracle".equals(databaseName)) {
            if (majorVersion > 11) {
                return new OracleDialect();
            }
            log.error("Oracle 12c or later is required.");
        }
        if ("MySQL".equals(databaseName)) {
            if (majorVersion >= 5 && minorVersion >= 7) {
                return new MySQLDialect();
            }
            log.error("MySQL 5.7 or later is required.");
        }
        log.error("{} {}.{} is not suppported.", new Object[]{databaseName, majorVersion, minorVersion});
        return null;
    }
}

