/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.hibernate.dialect;

import com.axelor.db.hibernate.dialect.AbstractJsonExtractFunction;
import com.axelor.db.hibernate.type.EncryptedTextType;
import com.axelor.db.hibernate.type.JsonSqlTypeDescriptor;
import com.axelor.db.hibernate.type.JsonType;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.MySQL57Dialect;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class MySQLDialect
extends MySQL57Dialect {
    public MySQLDialect() {
        this.registerColumnType(1111, "json");
        this.registerFunction("json_extract", new JsonExtractFunction((Type)StandardBasicTypes.STRING, null));
        this.registerFunction("json_extract_text", new JsonExtractFunction((Type)StandardBasicTypes.STRING, null));
        this.registerFunction("json_extract_boolean", new JsonExtractFunction((Type)StandardBasicTypes.BOOLEAN, null));
        this.registerFunction("json_extract_integer", new JsonExtractFunction((Type)StandardBasicTypes.INTEGER, "signed"));
        this.registerFunction("json_extract_decimal", new JsonExtractFunction((Type)StandardBasicTypes.BIG_DECIMAL, "decimal(64,4)"));
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        typeContributions.contributeType((BasicType)new JsonType(JsonSqlTypeDescriptor.INSTANCE));
        typeContributions.contributeType((BasicType)EncryptedTextType.INSTANCE);
    }

    static class JsonExtractFunction
    extends AbstractJsonExtractFunction {
        public JsonExtractFunction(Type type, String cast) {
            super("json_extract", type, cast);
        }

        @Override
        public String transformPath(List<String> path) {
            return path.stream().map(item -> item.substring(1, item.length() - 1)).collect(Collectors.joining(".", "'$.", "'"));
        }

        @Override
        protected String transformFunction(String func) {
            return String.format("json_unquote(%s)", func);
        }
    }
}

