/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.hibernate.dialect;

import com.axelor.db.hibernate.dialect.AbstractJsonExtractFunction;
import com.axelor.db.hibernate.type.EncryptedTextType;
import com.axelor.db.hibernate.type.JsonTextSqlTypeDescriptor;
import com.axelor.db.hibernate.type.JsonType;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.Oracle12cDialect;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class OracleDialect
extends Oracle12cDialect {
    public OracleDialect() {
        this.registerColumnType(-1, "clob");
        this.registerFunction("json_extract", new JsonValueFunction((Type)StandardBasicTypes.STRING, null));
        this.registerFunction("json_extract_text", new JsonValueFunction((Type)StandardBasicTypes.STRING, null));
        this.registerFunction("json_extract_boolean", new JsonValueFunction((Type)StandardBasicTypes.BOOLEAN, "number"));
        this.registerFunction("json_extract_integer", new JsonValueFunction((Type)StandardBasicTypes.INTEGER, "number"));
        this.registerFunction("json_extract_decimal", new JsonValueFunction((Type)StandardBasicTypes.BIG_DECIMAL, "number"));
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        typeContributions.contributeType((BasicType)new JsonType(JsonTextSqlTypeDescriptor.INSTANCE));
        typeContributions.contributeType((BasicType)EncryptedTextType.INSTANCE);
    }

    static class JsonValueFunction
    extends AbstractJsonExtractFunction {
        public JsonValueFunction(Type type, String cast) {
            super("json_value", type, cast);
        }

        @Override
        protected String transformPath(List<String> path) {
            return path.stream().map(item -> item.substring(1, item.length() - 1)).collect(Collectors.joining(".", "'$.", "'"));
        }
    }
}

