/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.hibernate.dialect;

import com.axelor.db.hibernate.dialect.AbstractJsonExtractFunction;
import com.axelor.db.hibernate.type.EncryptedTextType;
import com.axelor.db.hibernate.type.JsonType;
import com.axelor.db.hibernate.type.JsonbSqlTypeDescriptor;
import java.util.List;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.PostgreSQL94Dialect;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class PostgreSQLDialect
extends PostgreSQL94Dialect {
    public PostgreSQLDialect() {
        this.registerColumnType(1111, "jsonb");
        this.registerFunction("json_extract", new JsonExtractFunction((Type)StandardBasicTypes.STRING, null));
        this.registerFunction("json_extract_text", new JsonExtractFunction((Type)StandardBasicTypes.STRING, null));
        this.registerFunction("json_extract_boolean", new JsonExtractFunction((Type)StandardBasicTypes.BOOLEAN, "boolean"));
        this.registerFunction("json_extract_integer", new JsonExtractFunction((Type)StandardBasicTypes.INTEGER, "integer"));
        this.registerFunction("json_extract_decimal", new JsonExtractFunction((Type)StandardBasicTypes.BIG_DECIMAL, "numeric"));
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        typeContributions.contributeType((BasicType)new JsonType(JsonbSqlTypeDescriptor.INSTANCE));
        typeContributions.contributeType((BasicType)EncryptedTextType.INSTANCE);
    }

    static class JsonExtractFunction
    extends AbstractJsonExtractFunction {
        public JsonExtractFunction(Type type, String cast) {
            super("jsonb_extract_path_text", type, cast);
        }

        @Override
        protected String transformPath(List<String> path) {
            return String.join((CharSequence)", ", path);
        }
    }
}

