/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.hibernate.naming;

import com.axelor.db.hibernate.naming.PhysicalNamingStrategyImpl;
import com.axelor.db.internal.DBHelper;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitConstraintNameSource;
import org.hibernate.boot.model.naming.ImplicitForeignKeyNameSource;
import org.hibernate.boot.model.naming.ImplicitIndexNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyLegacyHbmImpl;
import org.hibernate.boot.model.naming.ImplicitUniqueKeyNameSource;
import org.hibernate.boot.model.naming.NamingHelper;

public class ImplicitNamingStrategyImpl
extends ImplicitNamingStrategyLegacyHbmImpl {
    private static final long serialVersionUID = -6890657585791247748L;
    public static final ImplicitNamingStrategyImpl INSTANCE = new ImplicitNamingStrategyImpl();

    public Identifier determineForeignKeyName(ImplicitForeignKeyNameSource source) {
        return this.determineContraintName((ImplicitConstraintNameSource)source, "FK_");
    }

    public Identifier determineUniqueKeyName(ImplicitUniqueKeyNameSource source) {
        return this.determineContraintName((ImplicitConstraintNameSource)source, "UK_");
    }

    public Identifier determineIndexName(ImplicitIndexNameSource source) {
        if (DBHelper.isOracle()) {
            return super.determineIndexName(source);
        }
        return this.determineContraintName((ImplicitConstraintNameSource)source, "_IDX");
    }

    private Identifier determineContraintName(ImplicitConstraintNameSource source, String prefixOrSuffix) {
        Identifier userProvidedIdentifier = source.getUserProvidedIdentifier();
        if (userProvidedIdentifier != null) {
            return userProvidedIdentifier;
        }
        Identifier tableName = source.getTableName();
        List columns = source.getColumnNames().stream().map(PhysicalNamingStrategyImpl::addUnderscores).collect(Collectors.toList());
        if (prefixOrSuffix.startsWith("_")) {
            String joined = columns.stream().map(Identifier::getText).collect(Collectors.joining("_"));
            return this.toIdentifier(tableName + "_" + joined + prefixOrSuffix, source.getBuildingContext());
        }
        return this.toIdentifier(NamingHelper.INSTANCE.generateHashedConstraintName(prefixOrSuffix, tableName, columns), source.getBuildingContext());
    }

    public Identifier determineJoinColumnName(ImplicitJoinColumnNameSource source) {
        if (source.getAttributePath() != null) {
            return super.determineJoinColumnName(source);
        }
        String name = source.getReferencedTableName().getText();
        return this.toIdentifier(name, source.getBuildingContext());
    }
}

