/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.hibernate.naming;

import com.axelor.common.StringUtils;
import java.util.Locale;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;

public class PhysicalNamingStrategyImpl
implements PhysicalNamingStrategy {
    public static final PhysicalNamingStrategyImpl INSTANCE = new PhysicalNamingStrategyImpl();

    public Identifier toPhysicalCatalogName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return PhysicalNamingStrategyImpl.addUnderscores(name);
    }

    public Identifier toPhysicalSchemaName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return PhysicalNamingStrategyImpl.addUnderscores(name);
    }

    public Identifier toPhysicalTableName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return PhysicalNamingStrategyImpl.addUnderscores(name);
    }

    public Identifier toPhysicalSequenceName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return PhysicalNamingStrategyImpl.addUnderscores(name);
    }

    public Identifier toPhysicalColumnName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return PhysicalNamingStrategyImpl.addUnderscores(name);
    }

    static Identifier addUnderscores(Identifier name) {
        if (name == null || StringUtils.isBlank((CharSequence)name.getText())) {
            return null;
        }
        return Identifier.toIdentifier((String)PhysicalNamingStrategyImpl.addUnderscores(name.getText()));
    }

    static String addUnderscores(String text) {
        StringBuilder buf = new StringBuilder(text.replace('.', '_'));
        for (int i = 1; i < buf.length() - 1; ++i) {
            if (!Character.isLowerCase(buf.charAt(i - 1)) || !Character.isUpperCase(buf.charAt(i)) || !Character.isLowerCase(buf.charAt(i + 1))) continue;
            buf.insert(i++, '_');
        }
        return buf.toString().toLowerCase(Locale.ROOT);
    }
}

