/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.hibernate.type;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import javax.persistence.PersistenceException;

public final class JsonFunction {
    public static final String DEFAULT_TYPE = "text";
    private static final Pattern NAME_PATTERN = Pattern.compile("\\w+");
    private static final Pattern TYPE_PATTERN = Pattern.compile("(text|boolean|integer|decimal)", 2);
    private String field;
    private String attribute;
    private String type;

    public JsonFunction(String field, String attribute, String type) {
        this.field = field;
        this.attribute = attribute;
        this.type = type;
    }

    public JsonFunction(String field, String attribute) {
        this(field, attribute, DEFAULT_TYPE);
    }

    private static String validateField(String name) {
        if (NAME_PATTERN.matcher(name).matches()) {
            return name;
        }
        throw new PersistenceException("Invalid field name: " + name);
    }

    private static String validateType(String name) {
        if (TYPE_PATTERN.matcher(name).matches()) {
            return name;
        }
        throw new PersistenceException("Invalid json type: " + name);
    }

    public static JsonFunction fromPath(String path) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"name cannot be null");
        Preconditions.checkArgument((path.indexOf(46) > -1 ? 1 : 0) != 0, (Object)"not a json path");
        int dot = path.indexOf(46);
        int col = path.indexOf("::");
        String type = col == -1 ? DEFAULT_TYPE : path.substring(col + 2);
        String rest = col == -1 ? path : path.substring(0, col);
        String field = rest.substring(0, dot);
        String attribute = rest.substring(dot + 1);
        return "long".equals(type) ? new JsonFunction(field, attribute, "integer") : new JsonFunction(field, attribute, type);
    }

    public String getField() {
        return this.field;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("json_extract_").append(JsonFunction.validateType(this.type)).append("(").append("self.").append(JsonFunction.validateField(this.field));
        for (String item : this.attribute.split("\\.")) {
            builder.append(", ").append("'").append(JsonFunction.validateField(item)).append("'");
        }
        return builder.append(")").toString();
    }
}

