/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.mapper;

import com.axelor.common.ResourceUtils;
import com.axelor.db.mapper.Adapter;
import com.axelor.db.mapper.Property;
import com.axelor.internal.asm.ClassReader;
import com.axelor.internal.asm.ClassVisitor;
import com.axelor.internal.asm.tree.ClassNode;
import com.axelor.internal.asm.tree.FieldInsnNode;
import com.axelor.internal.asm.tree.MethodNode;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class Mapper {
    private static final LoadingCache<Class<?>, Mapper> MAPPER_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).weakKeys().build(CacheLoader.from(Mapper::new));
    private static final Cache<Method, Annotation[]> ANNOTATION_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).weakKeys().build();
    private static final Object[] NULL_ARGUMENTS = new Object[0];
    private static final String PREFIX_COMPUTE = "compute";
    private static final String PREFIX_SET = "set";
    private Map<String, Method> getters = new HashMap<String, Method>();
    private Map<String, Method> setters = new HashMap<String, Method>();
    private Map<String, String> methods = new HashMap<String, String>();
    private Map<String, Class<?>> types = new HashMap();
    private Map<String, Property> fields = new HashMap<String, Property>();
    private Map<String, Set<String>> computeDependencies;
    private Set<Property> sequenceFields = new HashSet<Property>();
    private Property nameField;
    private Class<?> beanClass;

    private Mapper(Class<?> beanClass) {
        Preconditions.checkNotNull(beanClass);
        this.beanClass = beanClass;
        try {
            BeanInfo info = Introspector.getBeanInfo(beanClass, Object.class);
            for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                Class<?> type;
                Method setter;
                String name;
                block13: {
                    name = descriptor.getName();
                    Method getter = descriptor.getReadMethod();
                    setter = descriptor.getWriteMethod();
                    type = descriptor.getPropertyType();
                    if (getter != null) {
                        this.getters.put(name, getter);
                        this.methods.put(getter.getName(), name);
                        try {
                            Property property = new Property(beanClass, name, type, getter.getGenericReturnType(), this.getAnnotations(name, getter));
                            this.fields.put(name, property);
                            if (property.isSequence()) {
                                this.sequenceFields.add(property);
                            }
                            if (!property.isVirtual()) break block13;
                            try {
                                Method compute = beanClass.getDeclaredMethod(PREFIX_COMPUTE + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
                                this.methods.put(compute.getName(), name);
                            }
                            catch (NoSuchMethodException | SecurityException exception) {}
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                }
                if (setter == null) {
                    try {
                        setter = beanClass.getDeclaredMethod(PREFIX_SET + name.substring(0, 1).toUpperCase() + name.substring(1), type);
                        setter.setAccessible(true);
                    }
                    catch (NoSuchMethodException | SecurityException exception) {
                        // empty catch block
                    }
                }
                if (setter != null) {
                    this.setters.put(name, setter);
                    this.methods.put(setter.getName(), name);
                }
                this.types.put(name, type);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    private Annotation[] getAnnotations(String name, Method method) {
        Annotation[] found = (Annotation[])ANNOTATION_CACHE.getIfPresent((Object)method);
        if (found != null) {
            return found;
        }
        ArrayList<Annotation> all = new ArrayList<Annotation>();
        try {
            Field field = this.getField(this.beanClass, name);
            Annotation[] annotationArray = field.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation a = annotationArray[i];
                all.add(a);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Annotation a : method.getAnnotations()) {
            all.add(a);
        }
        found = all.toArray(new Annotation[0]);
        ANNOTATION_CACHE.put((Object)method, (Object)found);
        return found;
    }

    private Field getField(Class<?> klass, String name) {
        try {
            return klass.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            return this.getField(klass.getSuperclass(), name);
        }
    }

    public static Mapper of(Class<?> klass) {
        try {
            return (Mapper)MAPPER_CACHE.get(klass);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Property[] getProperties() {
        return this.fields.values().toArray(new Property[0]);
    }

    public Property getProperty(String name) {
        return this.fields.get(name);
    }

    public Property getProperty(Method method) {
        Preconditions.checkNotNull((Object)method);
        return this.getProperty(this.methods.get(method.getName()));
    }

    public Property getNameField() {
        if (this.nameField != null) {
            return this.nameField;
        }
        for (Property property : this.fields.values()) {
            if (!property.isNameColumn()) continue;
            this.nameField = property;
            return this.nameField;
        }
        this.nameField = this.getProperty("name");
        return this.nameField;
    }

    public Property[] getSequenceFields() {
        return this.sequenceFields.toArray(new Property[0]);
    }

    public Set<String> getComputeDependencies(Property property) {
        Preconditions.checkNotNull((Object)property);
        if (this.computeDependencies == null) {
            this.computeDependencies = this.findComputeDependencies();
        }
        return this.computeDependencies.get(property.getName());
    }

    private Map<String, Set<String>> findComputeDependencies() {
        ClassReader reader;
        String className = this.beanClass.getName().replace('.', '/');
        try {
            reader = new ClassReader(ResourceUtils.getResourceStream((String)(className + ".class")));
        }
        catch (IOException e) {
            return new HashMap<String, Set<String>>();
        }
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        return node.methods.stream().map(m -> (MethodNode)m).filter(m -> Modifier.isProtected(m.access)).filter(m -> m.name.startsWith(PREFIX_COMPUTE)).filter(m -> this.methods.containsKey(m.name)).collect(Collectors.toMap(m -> this.methods.get(m.name), m -> Arrays.stream(m.instructions.toArray()).filter(n -> n.getOpcode() == 180).filter(n -> n instanceof FieldInsnNode).map(n -> (FieldInsnNode)n).filter(n -> !n.name.equals(this.methods.get(m.name))).map(n -> n.name).collect(Collectors.toSet())));
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Method getGetter(String name) {
        return this.getters.get(name);
    }

    public Method getSetter(String name) {
        return this.setters.get(name);
    }

    public Object get(Object bean, String name) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((boolean)this.beanClass.isInstance(bean));
        Preconditions.checkArgument((!name.trim().equals("") ? 1 : 0) != 0);
        try {
            return this.getters.get(name).invoke(bean, NULL_ARGUMENTS);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object set(Object bean, String name, Object value) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((boolean)this.beanClass.isInstance(bean));
        Preconditions.checkArgument((!name.trim().equals("") ? 1 : 0) != 0);
        Method method = this.setters.get(name);
        if (method == null) {
            throw new IllegalArgumentException("The bean of type: " + this.beanClass.getName() + " has no property called: " + name);
        }
        Object oldValue = this.get(bean, name);
        Class<?> actualType = method.getParameterTypes()[0];
        Type genericType = method.getGenericParameterTypes()[0];
        Annotation[] annotations = this.getAnnotations(name, method);
        try {
            method.invoke(bean, Adapter.adapt(value, actualType, genericType, annotations));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return oldValue;
    }

    public static <T> T toBean(Class<T> klass, Map<String, Object> values) {
        Object bean;
        try {
            bean = klass.newInstance();
        }
        catch (Exception e2) {
            throw new IllegalArgumentException(e2);
        }
        if (values == null || values.isEmpty()) {
            return bean;
        }
        Mapper mapper = Mapper.of(klass);
        values.entrySet().stream().filter(e -> mapper.setters.containsKey(e.getKey())).forEach(e -> mapper.set(bean, (String)e.getKey(), e.getValue()));
        return bean;
    }

    public static Map<String, Object> toMap(Object bean) {
        if (bean == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Mapper mapper = Mapper.of(bean.getClass());
        for (Property p : mapper.getProperties()) {
            map.put(p.getName(), p.get(bean));
        }
        return map;
    }
}

