/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.mapper.types;

import com.axelor.db.mapper.TypeAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.persistence.Column;
import javax.validation.constraints.Digits;

public class DecimalAdapter
implements TypeAdapter<BigDecimal> {
    @Override
    public Object adapt(Object value, Class<?> actualType, Type genericType, Annotation[] annotations) {
        boolean empty;
        Integer scale = null;
        Boolean nullable = null;
        for (Annotation a : annotations) {
            if (a instanceof Digits) {
                scale = ((Digits)a).fraction();
            }
            if (!(a instanceof Column)) continue;
            nullable = ((Column)a).nullable();
        }
        boolean bl = empty = value == null || value instanceof String && "".equals(((String)value).trim());
        if (empty) {
            return nullable == Boolean.TRUE ? null : BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return this.adjust((BigDecimal)value, scale);
        }
        return this.adjust(new BigDecimal(value.toString()), scale);
    }

    private BigDecimal adjust(BigDecimal value, Integer scale) {
        if (scale != null) {
            return value.setScale((int)scale, RoundingMode.HALF_UP);
        }
        return value;
    }
}

