/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.mapper.types;

import com.axelor.db.mapper.TypeAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import javax.persistence.Column;

public class SimpleAdapter
implements TypeAdapter<Object> {
    @Override
    public Object adapt(Object value, Class<?> type, Type genericType, Annotation[] annotations) {
        if (value == null || value instanceof String && "".equals(((String)value).trim())) {
            return this.adaptNull(value, type, genericType, annotations);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.valueOf(value.toString());
        }
        try {
            return type.getConstructor(value.getClass()).newInstance(value);
        }
        catch (Exception exception) {
            if (type == String.class) {
                if (value == null || value instanceof String) {
                    return value;
                }
                return value.toString();
            }
            if (type == byte[].class && value instanceof String) {
                return ((String)value).getBytes();
            }
            if (type == Character.TYPE || type == Character.class) {
                return Character.valueOf(value.toString().charAt(0));
            }
            if (type == Byte.TYPE || type == Byte.class) {
                return Byte.valueOf(value.toString());
            }
            if (type == Short.TYPE || type == Short.class) {
                return Short.valueOf(value.toString());
            }
            if (type == Integer.TYPE || type == Integer.class) {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                return Integer.valueOf(value.toString());
            }
            if (type == Long.TYPE || type == Long.class) {
                return Long.valueOf(value.toString());
            }
            if (type == Float.TYPE || type == Float.class) {
                return Float.valueOf(value.toString());
            }
            if (type == Date.class) {
                return Date.valueOf(value.toString());
            }
            if (type == Time.class) {
                return Time.valueOf(value.toString());
            }
            if (type == Timestamp.class) {
                return Timestamp.valueOf(value.toString());
            }
            return value;
        }
    }

    public Object adaptNull(Object value, Class<?> type, Type genericType, Annotation[] annotations) {
        if (this.isNullable(type, annotations)) {
            return null;
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Short.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Character.TYPE) {
            return Character.valueOf(' ');
        }
        return null;
    }

    private boolean isNullable(Class<?> type, Annotation[] annotations) {
        if (type.isPrimitive()) {
            return false;
        }
        if (annotations == null || annotations.length == 0) {
            return true;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Column)) continue;
            return ((Column)annotation).nullable();
        }
        return false;
    }
}

