/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.search;

import com.axelor.auth.db.User;
import com.axelor.db.JpaSecurity;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.db.search.SearchModule;
import com.axelor.dms.db.DMSFile;
import com.axelor.meta.db.MetaFile;
import com.axelor.rpc.filter.Filter;
import com.axelor.rpc.filter.JPQLFilter;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SearchService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchService.class);
    private boolean enabled = SearchModule.isEnabled();
    @Inject
    private Provider<EntityManager> emp;
    @Inject
    private Provider<JpaSecurity> security;

    private FullTextEntityManager getFullTextEntityManager() {
        if (this.isEnabled()) {
            return Search.getFullTextEntityManager((EntityManager)((EntityManager)this.emp.get()));
        }
        throw new IllegalStateException("Full-text search is not enabled.");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Transactional
    public void createIndex(boolean force) throws InterruptedException {
        QueryBuilder builder;
        org.apache.lucene.search.Query query;
        FullTextEntityManager ftem;
        if (!force & (ftem = this.getFullTextEntityManager()).createFullTextQuery(query = (builder = ftem.getSearchFactory().buildQueryBuilder().forEntity(User.class).get()).keyword().wildcard().onField("code").matching((Object)"*").createQuery(), new Class[]{User.class}).setMaxResults(1).getResultList().size() > 0) {
            return;
        }
        LOGGER.info("Initializing search indexes....");
        ftem.createIndexer(new Class[0]).startAndWait();
    }

    public void doSearch(Consumer<FullTextEntityManager> runner) {
        runner.accept(this.getFullTextEntityManager());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Long> fullTextSearch(Class<? extends Model> entityType, String searchText, int limit) throws IOException {
        ((JpaSecurity)this.security.get()).check(JpaSecurity.CAN_READ, entityType, new Long[0]);
        Filter filter = ((JpaSecurity)this.security.get()).getFilter(JpaSecurity.CAN_READ, entityType, new Long[0]);
        FullTextEntityManager em = this.getFullTextEntityManager();
        ArrayList<Long> all = new ArrayList<Long>();
        if (!em.getSearchFactory().getIndexedTypes().contains(entityType)) {
            return all;
        }
        Mapper mapper = Mapper.of(entityType);
        Property nameField = mapper.getNameField();
        ArrayList<String> names = new ArrayList<String>();
        QueryBuilder builder = em.getSearchFactory().buildQueryBuilder().forEntity(entityType).get();
        if (nameField != null) {
            names.add(nameField.getName());
        }
        if (DMSFile.class.isAssignableFrom(entityType)) {
            names.add("metaFile.filePath");
        }
        if (MetaFile.class.isAssignableFrom(entityType)) {
            names.add("filePath");
        }
        if (names.isEmpty()) {
            return all;
        }
        org.apache.lucene.search.Query query = ((TermMatchingContext)builder.keyword().wildcard().onFields(names.toArray(new String[0])).ignoreFieldBridge()).matching((Object)("*" + searchText + "*")).createQuery();
        LOGGER.debug("Searching {} for {}", (Object)entityType.getName(), (Object)query);
        try (IndexReader reader = em.getSearchFactory().getIndexReaderAccessor().open(new Class[]{entityType});){
            IndexSearcher searcher = new IndexSearcher(reader);
            ScoreDoc after = null;
            int topCount = limit;
            while (true) {
                Object docs2222;
                ArrayList<Long> found = new ArrayList<Long>();
                try {
                    docs2222 = searcher.searchAfter(after, query, limit);
                    for (ScoreDoc doc : docs2222.scoreDocs) {
                        found.add(Long.parseLong(searcher.doc(doc.doc).get("id")));
                    }
                    after = docs2222.totalHits < topCount ? null : docs2222.scoreDocs[docs2222.scoreDocs.length - 1];
                }
                catch (IOException docs2222) {
                    // empty catch block
                }
                if (filter == null) {
                    docs2222 = found;
                    return docs2222;
                }
                Filter check = Filter.and(new JPQLFilter("self.id in ?", found), filter, new Filter[0]);
                Query<? extends Model> qm = check.build(entityType);
                for (List item : qm.select("id").values(found.size(), 0)) {
                    all.add((Long)item.get(0));
                    if (all.size() != limit) continue;
                    ArrayList<Long> arrayList = all;
                    return arrayList;
                }
                if (after == null || (topCount -= all.size()) <= 0) {
                    ArrayList<Long> arrayList = all;
                    return arrayList;
                }
                continue;
                break;
            }
        }
    }
}

