/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.tenants;

import com.axelor.db.tenants.AbstractTenantFilter;
import java.io.IOException;
import java.util.Map;
import javax.inject.Singleton;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.shiro.web.util.WebUtils;

@Singleton
public class PostSessionTenantFilter
extends AbstractTenantFilter {
    private static final String INDEX_PAGE = "/index.jsp";

    @Override
    public void doFilterInternal(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        if (INDEX_PAGE.equals(req.getServletPath())) {
            String tenantId;
            HttpSession session = req.getSession();
            Map<String, String> tenants = this.getTenants(false);
            if (!tenants.containsKey(tenantId = (String)session.getAttribute("tenantId"))) {
                session.invalidate();
                WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)"/");
                return;
            }
            req.getSession().setAttribute("tenantMap", this.getTenants(false));
        }
        chain.doFilter(request, response);
    }
}

