/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.tenants;

import com.axelor.common.StringUtils;
import com.axelor.db.tenants.TenantConfig;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TenantConfigImpl
implements TenantConfig {
    private Boolean active;
    private Boolean visible;
    private String tenantId;
    private String tenantName;
    private String tenantHosts;
    private String tenantRoles;
    private String jndiDataSource;
    private String jdbcDriver;
    private String jdbcUrl;
    private String jdbcUser;
    private String jdbcPassword;
    private static final Pattern PATTERN_DB_NAME = Pattern.compile("db\\.(.*?)\\.name");
    private static final Map<String, TenantConfig> CONFIGS = new ConcurrentHashMap<String, TenantConfig>();

    private TenantConfigImpl() {
    }

    public static List<TenantConfig> findByHost(Properties props, String host) {
        ArrayList<TenantConfig> all = new ArrayList<TenantConfig>();
        for (String key : props.stringPropertyNames()) {
            String tenantId;
            Matcher matcher = PATTERN_DB_NAME.matcher(key);
            if (!matcher.matches() || !TenantConfigImpl.matches(props, tenantId = matcher.group(1), host)) continue;
            all.add(TenantConfigImpl.findById(props, matcher.group(1)));
        }
        if (all.isEmpty() && TenantConfigImpl.matches(props, "default", host)) {
            all.add(TenantConfigImpl.findById(props, "default"));
        }
        try {
            all.sort((a, b) -> a.getTenantName().compareTo(b.getTenantName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        all.removeIf(Objects::isNull);
        return all;
    }

    public static TenantConfig findById(Properties props, String tenantId) {
        if (CONFIGS.containsKey(tenantId)) {
            return CONFIGS.get(tenantId);
        }
        String prefix = "db." + tenantId;
        TenantConfigImpl cfg = new TenantConfigImpl();
        String active = TenantConfigImpl.get(props, prefix, "active");
        String visible = TenantConfigImpl.get(props, prefix, "visible");
        cfg.active = active == null || active == "true";
        cfg.visible = visible == null || visible == "true";
        cfg.tenantId = tenantId;
        cfg.tenantName = TenantConfigImpl.get(props, prefix, "name");
        cfg.tenantHosts = TenantConfigImpl.get(props, prefix, "hosts");
        cfg.tenantRoles = TenantConfigImpl.get(props, prefix, "roles");
        cfg.jndiDataSource = TenantConfigImpl.get(props, prefix, "datasource");
        cfg.jdbcDriver = TenantConfigImpl.get(props, prefix, "driver");
        cfg.jdbcUrl = TenantConfigImpl.get(props, prefix, "url");
        cfg.jdbcUser = TenantConfigImpl.get(props, prefix, "user");
        cfg.jdbcPassword = TenantConfigImpl.get(props, prefix, "password");
        if (cfg.jndiDataSource == null && (cfg.jdbcDriver == null || cfg.jdbcUrl == null)) {
            return null;
        }
        CONFIGS.put(tenantId, cfg);
        return cfg;
    }

    private static boolean matches(Properties props, String tenantId, String host) {
        String key = "db." + tenantId + ".hosts";
        String hosts = props.getProperty(key, "");
        return StringUtils.isBlank((CharSequence)hosts) || Arrays.asList(hosts.split(",")).contains(host);
    }

    private static String get(Properties props, String prefix, String name) {
        String key = prefix + "." + name;
        String val = props.getProperty(key);
        return StringUtils.isBlank((CharSequence)val) ? null : val;
    }

    @Override
    public Boolean getActive() {
        return this.active;
    }

    @Override
    public Boolean getVisible() {
        return this.visible;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getTenantName() {
        return this.tenantName;
    }

    @Override
    public String getTenantHosts() {
        return this.tenantHosts;
    }

    @Override
    public String getTenantRoles() {
        return this.tenantRoles;
    }

    @Override
    public String getJndiDataSource() {
        return this.jndiDataSource;
    }

    @Override
    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    @Override
    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @Override
    public String getJdbcUser() {
        return this.jdbcUser;
    }

    @Override
    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tenantId", (Object)this.tenantId).add("tenantName", (Object)this.tenantName).add("jndiDataSource", (Object)this.jndiDataSource).add("jdbcDriver", (Object)this.jdbcDriver).add("jdbcUrl", (Object)this.jdbcUrl).omitNullValues().toString();
    }
}

