/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.tenants;

import com.axelor.app.AppSettings;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.common.StringUtils;
import com.axelor.db.tenants.TenantConfig;
import com.axelor.db.tenants.TenantConfigImpl;
import com.axelor.db.tenants.TenantConfigProvider;
import java.util.List;

public class TenantConfigProviderImpl
implements TenantConfigProvider {
    @Override
    public TenantConfig find(String tenantId) {
        return TenantConfigImpl.findById(AppSettings.get().getProperties(), tenantId);
    }

    @Override
    public List<TenantConfig> findAll(String host) {
        return TenantConfigImpl.findByHost(AppSettings.get().getProperties(), host);
    }

    @Override
    public boolean hasAccess(User user, TenantConfig config) {
        String roles = config.getTenantRoles();
        if (user == null) {
            return false;
        }
        return StringUtils.isBlank((CharSequence)roles) || AuthUtils.isAdmin(user) || AuthUtils.hasRole(user, roles.split(","));
    }
}

