/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.tenants;

import com.axelor.db.tenants.TenantConfig;
import com.axelor.db.tenants.TenantConfigProvider;
import com.axelor.db.tenants.TenantNotFoundException;
import com.axelor.db.tenants.TenantSupport;
import com.google.common.base.Preconditions;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.hibernate.engine.jdbc.connections.spi.AbstractDataSourceBasedMultiTenantConnectionProviderImpl;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantConnectionProvider
extends AbstractDataSourceBasedMultiTenantConnectionProviderImpl
implements ServiceRegistryAwareService,
Stoppable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantConnectionProvider.class);
    private TenantConfigProvider configProvider;
    private Map<String, DataSource> dataSourceMap;

    private Map<String, DataSource> dataSourceMap() {
        if (this.dataSourceMap == null) {
            this.dataSourceMap = new ConcurrentHashMap<String, DataSource>();
        }
        return this.dataSourceMap;
    }

    protected final DataSource selectAnyDataSource() {
        return this.selectDataSource("default");
    }

    protected final DataSource selectDataSource(String tenantIdentifier) {
        if (this.configProvider.find(tenantIdentifier) == null) {
            this.dataSourceMap().remove(tenantIdentifier);
            LOGGER.debug("no such tenant found: {}", (Object)tenantIdentifier);
            throw new TenantNotFoundException("No such tenant found: " + tenantIdentifier);
        }
        DataSource dataSource = this.dataSourceMap().get(tenantIdentifier);
        LOGGER.debug("using tenant: {}", (Object)tenantIdentifier);
        if (dataSource == null) {
            dataSource = this.createDataSource(this.validate(this.configProvider.find(tenantIdentifier)));
            this.dataSourceMap().put(tenantIdentifier, dataSource);
        }
        return dataSource;
    }

    private DataSource createDataSource(TenantConfig config) {
        LOGGER.debug("creating datasource for tenant config: {}", (Object)config);
        HikariConfig hc = new HikariConfig();
        hc.setDataSourceJNDI(config.getJndiDataSource());
        hc.setDriverClassName(config.getJdbcDriver());
        hc.setJdbcUrl(config.getJdbcUrl());
        hc.setUsername(config.getJdbcUser());
        hc.setPassword(config.getJdbcPassword());
        hc.setAutoCommit(false);
        return new HikariDataSource(hc);
    }

    private TenantConfig validate(TenantConfig config) {
        Preconditions.checkNotNull((Object)config, (Object)"invalid tenant config.");
        if (config.getJndiDataSource() != null) {
            return config;
        }
        Preconditions.checkState((config.getJdbcDriver() != null ? 1 : 0) != 0, (Object)"no jdbc driver specified.");
        Preconditions.checkState((config.getJdbcUrl() != null ? 1 : 0) != 0, (Object)"no jdbc url specified.");
        return config;
    }

    public void stop() {
        if (this.dataSourceMap != null) {
            this.dataSourceMap.clear();
            this.dataSourceMap = null;
        }
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.configProvider = TenantSupport.get().getConfigProvider();
        LOGGER.debug("using tenant config provider: {}", (Object)this.configProvider.getClass().getName());
    }
}

