/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.dms.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="DMS_FILE_TAG")
public class DMSFileTag
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DMS_FILE_TAG_SEQ")
    @SequenceGenerator(name="DMS_FILE_TAG_SEQ", sequenceName="DMS_FILE_TAG_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @NotNull
    @Size(min=2)
    @Column(unique=true)
    private String code;
    @HashKey
    @NameColumn
    @NotNull
    @Size(min=2)
    @Column(unique=true)
    private String name;
    @Widget(selection="dms.tag.style.selection")
    private String style;

    public DMSFileTag() {
    }

    public DMSFileTag(String code, String name) {
        this.code = code;
        this.name = name;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DMSFileTag)) {
            return false;
        }
        DMSFileTag other = (DMSFileTag)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        if (!Objects.equals(this.getCode(), other.getCode())) {
            return false;
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(1515922484, this.getCode(), this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("name", (Object)this.getName()).add("style", (Object)this.getStyle()).omitNullValues().toString();
    }
}

