/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.event;

import com.axelor.event.Observer;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.LinkedKeyBinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
class EventBus {
    private final Injector injector;
    private final AtomicReference<Map<Class<?>, List<Observer>>> observersRef = new AtomicReference();
    private final LoadingCache<Class<?>, Map<Map.Entry<Type, Set<Annotation>>, List<Observer>>> observersCache = CacheBuilder.newBuilder().weakKeys().build(CacheLoader.from(k -> new ConcurrentHashMap()));

    @Inject
    public EventBus(Injector injector) {
        this.injector = injector;
    }

    private Map<Class<?>, List<Observer>> findObservers() {
        HashMap observers = new HashMap();
        this.injector.getAllBindings().entrySet().stream().filter(entry -> !(entry.getValue() instanceof LinkedKeyBinding)).map(Map.Entry::getKey).map(Key::getTypeLiteral).map(TypeLiteral::getRawType).flatMap(t -> Arrays.stream(t.getDeclaredMethods())).filter(Observer::isObserver).map(Observer::new).forEach(o -> observers.computeIfAbsent(o.eventRawType, k -> new ArrayList()).add(o));
        observers.values().forEach(items -> Collections.sort(items, Observer::compareTo));
        return observers;
    }

    private List<Observer> find(Class<?> runtimeType, Type eventType, Set<Annotation> qualifiers) {
        List found = this.observersRef.updateAndGet(observers -> observers != null ? observers : this.findObservers()).getOrDefault(runtimeType, Collections.emptyList());
        Set annotations = Optional.ofNullable(qualifiers).orElse(Collections.emptySet());
        return found.stream().filter(o -> o.matches(eventType, annotations)).collect(Collectors.toList());
    }

    public void fire(Object event, Type eventType, Set<Annotation> qualifiers) {
        Class<?> eventClass = event.getClass();
        Map observersByTypeAndQualifiers = (Map)this.observersCache.getUnchecked(eventClass);
        List foundObservers = observersByTypeAndQualifiers.computeIfAbsent(new AbstractMap.SimpleImmutableEntry<Type, Set<Annotation>>(eventType, qualifiers), k -> this.find(eventClass, (Type)k.getKey(), (Set)k.getValue()));
        foundObservers.forEach(o -> o.invoke(event));
    }
}

