/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.event;

import com.axelor.event.Event;
import com.axelor.event.EventBus;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

class EventImpl<T>
implements Event<T> {
    private EventBus eventBus;
    private Type eventType;
    private Set<Annotation> qualifiers;

    @Inject
    public EventImpl(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public Type getEventType() {
        return this.eventType;
    }

    public void setEventType(Type eventType) {
        this.eventType = eventType;
    }

    public void addQualifier(Annotation qualifier) {
        if (this.qualifiers == null) {
            this.qualifiers = new HashSet<Annotation>();
        }
        this.qualifiers.add(qualifier);
    }

    @Override
    public void fire(T event) {
        this.eventBus.fire(event, this.eventType, this.qualifiers);
    }

    @Override
    public Event<T> select(Annotation ... qualifiers) {
        if (qualifiers == null || qualifiers.length == 0) {
            return this;
        }
        EventImpl<T> copy = new EventImpl<T>(this.eventBus);
        copy.eventType = this.eventType;
        copy.qualifiers = new HashSet<Annotation>(Optional.ofNullable(this.qualifiers).orElse(Collections.emptySet()));
        Arrays.stream(qualifiers).forEach(copy.qualifiers::add);
        return copy;
    }
}

