/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.event;

import com.axelor.event.Event;
import com.axelor.event.EventImpl;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.MoreTypes;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Qualifier;

public class EventModule
extends AbstractModule {
    protected void configure() {
        this.bindListener(Matchers.any(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                Set injectionPoints = EventModule.findInjectionPoints(type);
                if (!injectionPoints.isEmpty()) {
                    encounter.register(new EventTypeInjector(injectionPoints));
                }
            }
        });
    }

    private static boolean checkDependencies(InjectionPoint injectionPoint) {
        return injectionPoint.getDependencies().stream().map(Dependency::getKey).map(Key::getTypeLiteral).map(TypeLiteral::getRawType).anyMatch(t -> t == Event.class);
    }

    private static Set<InjectionPoint> findInjectionPoints(TypeLiteral<?> type) {
        InjectionPoint constructorInjectionPoint;
        HashSet<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();
        InjectionPoint.forInstanceMethodsAndFields(type).stream().filter(ip -> ip.getMember() instanceof Field && EventModule.checkDependencies(ip)).forEach(injectionPoints::add);
        if (EventModule.hasInjectableConstructor(type) && EventModule.checkDependencies(constructorInjectionPoint = InjectionPoint.forConstructorOf(type))) {
            injectionPoints.add(constructorInjectionPoint);
        }
        return injectionPoints;
    }

    public static boolean hasInjectableConstructor(TypeLiteral<?> type) {
        boolean found = false;
        for (Constructor<?> ctor : MoreTypes.getRawType((Type)type.getType()).getDeclaredConstructors()) {
            if (ctor.getAnnotation(Inject.class) == null && ctor.getAnnotation(javax.inject.Inject.class) == null) continue;
            if (found) {
                return false;
            }
            found = true;
        }
        return found;
    }

    private static class EventTypeInjector<T>
    implements MembersInjector<T> {
        private Set<InjectionPoint> injectionPoints;

        public EventTypeInjector(Set<InjectionPoint> injectionPoints) {
            this.injectionPoints = injectionPoints;
        }

        public void injectMembers(T instance) {
            this.injectionPoints.forEach(ip -> this.injectMembers(instance, (InjectionPoint)ip));
        }

        private void injectMembers(T instance, Field field) {
            EventImpl event;
            field.setAccessible(true);
            try {
                event = (EventImpl)field.get(instance);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new IllegalArgumentException(e);
            }
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            event.setEventType(type.getActualTypeArguments()[0]);
            for (Annotation annotation : field.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(Qualifier.class)) continue;
                event.addQualifier(annotation);
            }
        }

        private void injectMembers(T instance, InjectionPoint ip) {
            if (ip.getMember() instanceof Field) {
                this.injectMembers(instance, (Field)ip.getMember());
            } else if (ip.getMember() instanceof Constructor) {
                Arrays.stream(ip.getMember().getDeclaringClass().getDeclaredFields()).filter(field -> field.getAnnotation(javax.inject.Inject.class) == null).filter(field -> field.getType() == Event.class).forEach(field -> this.injectMembers(instance, (Field)field));
            } else {
                throw new IllegalArgumentException("Unexpected injection point member type");
            }
        }
    }
}

