/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.event;

import com.axelor.event.ObserverException;
import com.axelor.event.Observes;
import com.axelor.event.Priority;
import com.axelor.inject.Beans;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.inject.Qualifier;

class Observer
implements Comparable<Observer> {
    public final Method method;
    public final Type eventActualType;
    public final Class<?> eventRawType;
    public final Class<?> declaringClass;
    private int priority;
    private Set<Annotation> qualifiers = new HashSet<Annotation>();

    public Observer(Method method) {
        assert (method.getParameters().length == 1);
        Parameter param = method.getParameters()[0];
        for (Annotation annotation : param.getAnnotations()) {
            if (annotation instanceof Priority) {
                this.priority = ((Priority)annotation).value();
            }
            if (!annotation.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            this.qualifiers.add(annotation);
        }
        this.method = method;
        this.method.setAccessible(true);
        this.declaringClass = method.getDeclaringClass();
        this.eventActualType = param.getParameterizedType();
        this.eventRawType = param.getType();
    }

    public boolean matches(Type eventType, Set<Annotation> qualifiers) {
        return this.matches(eventType) && this.hasQualifiers(qualifiers);
    }

    public boolean matches(Type eventType) {
        if (this.isUnbounded(eventType) && !this.isUnbounded(this.eventActualType)) {
            return false;
        }
        return TypeToken.of((Type)eventType).isSubtypeOf(this.eventActualType);
    }

    private boolean isUnbounded(Type type) {
        if (type instanceof ParameterizedType) {
            for (Type t : ((ParameterizedType)type).getActualTypeArguments()) {
                if (!(t instanceof WildcardType) || !t.getTypeName().equals("?")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasQualifiers(Set<Annotation> qualifiers) {
        Objects.requireNonNull(qualifiers, "qualifiers cannot be null");
        if (this.qualifiers.isEmpty()) {
            return true;
        }
        if (qualifiers.isEmpty()) {
            return false;
        }
        return this.qualifiers.stream().allMatch(o -> qualifiers.stream().anyMatch(o::equals));
    }

    public static boolean isObserver(Method method) {
        return !Modifier.isAbstract(method.getModifiers()) && !Modifier.isAbstract(method.getDeclaringClass().getModifiers()) && method.getParameterCount() == 1 && method.getParameters()[0].isAnnotationPresent(Observes.class);
    }

    public void invoke(Object event) {
        Object target = Beans.get(this.declaringClass);
        try {
            this.method.invoke(target, event);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new ObserverException(throwable);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(Observer o) {
        return this.priority - o.priority;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Observer)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Observer other = (Observer)obj;
        return Objects.equals(this.method, other.method);
    }

    public int hashCode() {
        return Objects.hash(31, this.method);
    }

    public String toString() {
        return "Observer(method=" + this.method + ", qualifiers=" + this.qualifiers + ")";
    }
}

