/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.inject;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class Beans {
    private static Beans instance;
    private Injector injector;

    @Inject
    private Beans(Injector injector) {
        this.injector = injector;
        instance = this;
    }

    private static Beans get() {
        if (instance == null || Beans.instance.injector == null) {
            throw new RuntimeException("Guice is not initialized.");
        }
        return instance;
    }

    public static <T> T get(Class<T> type) {
        return (T)Beans.get().injector.getInstance(type);
    }

    public static <T> T get(Class<T> type, Annotation qualifier) {
        return (T)Beans.get().injector.getInstance(Key.get(type, (Annotation)qualifier));
    }

    public static <T> T inject(T bean) {
        Beans.get().injector.injectMembers(bean);
        return bean;
    }
}

