/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.inject.logger;

import com.axelor.inject.logger.LoggerProvider;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.ProvisionListener;
import org.slf4j.Logger;

final class LoggerProvisionListener
implements ProvisionListener {
    LoggerProvisionListener() {
    }

    private boolean isLoggerDependency(Dependency<?> dependency) {
        return dependency != null && dependency.getKey().getTypeLiteral().getRawType().isAssignableFrom(Logger.class);
    }

    public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
        provision.getDependencyChain().stream().map(d -> d.getDependency()).filter(this::isLoggerDependency).map(d -> d.getInjectionPoint().getDeclaringType().getRawType()).forEach(type -> {
            LoggerProvider.NAME.set(type.getName());
            try {
                provision.provision();
            }
            finally {
                LoggerProvider.NAME.remove();
            }
        });
    }
}

