/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.mail;

import com.axelor.common.StringUtils;
import com.axelor.mail.MailFileTypeMap;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.FileTypeMap;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.PreencodedMimeBodyPart;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public final class MailBuilder {
    private static final Pattern IMAGE_DATA_PATTERN = Pattern.compile("data:([^;]+);base64");
    private Session session;
    private String subject;
    private String from = "";
    private String sender = "";
    private Set<String> toRecipients = new LinkedHashSet<String>();
    private Set<String> ccRecipients = new LinkedHashSet<String>();
    private Set<String> bccRecipients = new LinkedHashSet<String>();
    private Set<String> replyRecipients = new LinkedHashSet<String>();
    private final List<Content> contents = new ArrayList<Content>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private final FileTypeMap fileTypeMap = new MailFileTypeMap();
    private boolean hasText;
    private boolean hasHtml;
    private boolean hasInline;
    private boolean hasAttach;

    public MailBuilder(Session session) {
        this.session = session;
    }

    public MailBuilder subject(String subject) {
        this.subject = subject;
        return this;
    }

    private MailBuilder addAll(Collection<String> to, String ... recipients) {
        Preconditions.checkNotNull((Object)recipients, (Object)"recipients can't be null");
        for (String email : recipients) {
            Preconditions.checkNotNull((Object)email, (Object)"email can't be null");
        }
        Collections.addAll(to, recipients);
        return this;
    }

    public MailBuilder to(String ... recipients) {
        return this.addAll(this.toRecipients, recipients);
    }

    public MailBuilder cc(String ... recipients) {
        Preconditions.checkNotNull((Object)recipients, (Object)"recipients can't be null");
        return this.addAll(this.ccRecipients, recipients);
    }

    public MailBuilder bcc(String ... recipients) {
        return this.addAll(this.bccRecipients, recipients);
    }

    public MailBuilder replyTo(String ... recipients) {
        return this.addAll(this.replyRecipients, recipients);
    }

    public MailBuilder from(String from) {
        this.from = from;
        return this;
    }

    public MailBuilder sender(String sender) {
        this.sender = sender;
        return this;
    }

    public MailBuilder header(String name, String value) {
        Preconditions.checkNotNull((Object)name, (Object)"header name can't be null");
        this.headers.put(name, value);
        return this;
    }

    public MailBuilder text(String text) {
        this.hasText = true;
        return this.text(text, false);
    }

    public MailBuilder html(String text) {
        Document doc = Jsoup.parse((String)text);
        Elements images = doc.getElementsByAttributeValueMatching("src", IMAGE_DATA_PATTERN);
        images.forEach(img -> {
            String src = img.attr("src");
            Matcher matcher = IMAGE_DATA_PATTERN.matcher(src);
            if (matcher.find()) {
                Content content = new Content();
                String cid = "image" + UUID.randomUUID().toString();
                content.cid = "<" + cid + ">";
                content.name = img.attr("title");
                content.imageData = src.split(",")[1];
                content.imageType = matcher.group(1);
                img.attr("src", "cid:" + cid);
                this.contents.add(content);
            }
        });
        this.hasHtml = true;
        return this.text(doc.body().html(), true);
    }

    private MailBuilder text(String text, boolean html) {
        Preconditions.checkNotNull((Object)text, (Object)"text can't be null");
        Content content = new Content();
        content.text = text;
        content.html = html;
        this.contents.add(content);
        return this;
    }

    public MailBuilder attach(String name, String link) {
        return this.attach(name, link, null);
    }

    public MailBuilder attach(String name, String link, String cid) {
        Preconditions.checkNotNull((Object)link, (Object)"link can't be null");
        Content content = new Content();
        content.name = name;
        content.file = link;
        content.cid = cid;
        this.contents.add(content);
        if (cid != null && cid.indexOf(60) == 0) {
            this.hasInline = true;
        } else {
            this.hasAttach = true;
        }
        return this;
    }

    public MailBuilder inline(String name, String link) {
        Preconditions.checkNotNull((Object)link, (Object)"link can't be null");
        Content content = new Content();
        content.name = name;
        content.file = link;
        content.cid = "<" + name + ">";
        content.inline = true;
        this.contents.add(content);
        this.hasInline = true;
        return this;
    }

    public MimeMessage build() throws MessagingException, IOException {
        return this.build(null);
    }

    public MimeMessage build(final String messageId) throws MessagingException, IOException {
        MimeMultipart rootContainer;
        MimeMessage message = new MimeMessage(this.session){

            protected void updateMessageID() throws MessagingException {
                if (StringUtils.isBlank((CharSequence)messageId)) {
                    super.updateMessageID();
                } else {
                    this.setHeader("Message-ID", messageId);
                }
            }
        };
        message.setSubject(this.subject);
        message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)Joiner.on((String)",").join(this.toRecipients)));
        message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)Joiner.on((String)",").join(this.ccRecipients)));
        message.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)Joiner.on((String)",").join(this.bccRecipients)));
        message.setReplyTo((Address[])InternetAddress.parse((String)Joiner.on((String)",").join(this.replyRecipients)));
        if (!StringUtils.isBlank((CharSequence)this.from)) {
            message.setFrom((Address)new InternetAddress(this.from));
        }
        if (!StringUtils.isBlank((CharSequence)this.sender)) {
            message.setSender((Address)new InternetAddress(this.sender));
        }
        for (String name : this.headers.keySet()) {
            message.setHeader(name, this.headers.get(name));
        }
        if (this.contents.size() == 1 && (this.hasText || this.hasHtml)) {
            this.contents.get(0).apply((MimePart)message);
            return message;
        }
        MimeMultipart inlineContainer = rootContainer = new MimeMultipart();
        MimeMultipart bodyContainer = rootContainer;
        rootContainer.setSubType("mixed");
        if (this.hasHtml && this.hasInline) {
            bodyContainer = inlineContainer = new MimeMultipart("related");
            this.addPart(rootContainer, inlineContainer, 0);
            if (this.hasText) {
                bodyContainer = new MimeMultipart("alternative");
                this.addPart(inlineContainer, bodyContainer, 0);
            }
        } else if (this.hasHtml && this.hasText) {
            if (this.hasInline || this.hasAttach) {
                bodyContainer = new MimeMultipart("alternative");
                this.addPart(rootContainer, bodyContainer, 0);
            } else {
                rootContainer.setSubType("alternative");
            }
        }
        StringBuilder text = new StringBuilder();
        StringBuilder html = new StringBuilder();
        for (Content content : this.contents) {
            MimeBodyPart part;
            if (content.file != null) {
                part = new MimeBodyPart();
                try {
                    URL link = new URL(content.file);
                    part.setDataHandler(new DataHandler((DataSource)new URLDataSource(link)));
                }
                catch (MalformedURLException e) {
                    FileDataSource fds = new FileDataSource(new File(content.file));
                    fds.setFileTypeMap(this.fileTypeMap);
                    part.setDataHandler(new DataHandler((DataSource)fds));
                }
                part.setFileName(content.name);
                if (content.cid != null) {
                    part.setContentID(content.cid);
                }
                if (content.inline) {
                    part.setDisposition("inline");
                    inlineContainer.addBodyPart((BodyPart)part);
                    continue;
                }
                part.setDisposition("attachment");
                rootContainer.addBodyPart((BodyPart)part);
                continue;
            }
            if (content.imageData != null) {
                part = new PreencodedMimeBodyPart("base64");
                part.setContentID(content.cid);
                part.setContent((Object)content.imageData, content.imageType);
                part.setFileName(content.name);
                part.setDisposition("inline");
                inlineContainer.addBodyPart((BodyPart)part);
                continue;
            }
            if (content.html) {
                html.append(content.text);
                continue;
            }
            text.append(content.text);
        }
        MimeBodyPart htmlPart = new MimeBodyPart();
        MimeBodyPart textPart = new MimeBodyPart();
        if (html.length() > 0) {
            htmlPart.setText(html.toString(), "UTF-8", "html");
            bodyContainer.addBodyPart((BodyPart)htmlPart, 0);
        }
        if (text.length() > 0) {
            textPart.setText(text.toString(), "UTF-8");
            bodyContainer.addBodyPart((BodyPart)textPart, 0);
        }
        message.setContent((Multipart)rootContainer);
        return message;
    }

    private void addPart(MimeMultipart root, MimeMultipart content, int index) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setContent((Multipart)content);
        root.addBodyPart((BodyPart)part, index);
    }

    public MimeMessage send(Date date) throws MessagingException, IOException {
        MimeMessage message = this.build();
        try {
            message.setSentDate(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Transport.send((Message)message);
        return message;
    }

    public MimeMessage send() throws MessagingException, IOException {
        return this.send(new Date());
    }

    private class Content {
        String cid;
        String text;
        String name;
        String file;
        String imageData;
        String imageType;
        boolean inline;
        boolean html;

        private Content() {
        }

        public MimePart apply(MimePart message) throws MessagingException {
            if (this.text == null) {
                return message;
            }
            if (this.html) {
                message.setText(this.text, "UTF-8", "html");
            } else {
                message.setText(this.text);
            }
            return message;
        }
    }
}

