/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.mail;

import com.axelor.mail.MailAccount;
import com.axelor.mail.MailBuilder;
import java.io.IOException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;

public final class MailSender {
    private Session session;

    public MailSender(MailAccount account) {
        this.session = account.getSession();
    }

    public MailBuilder compose() {
        return new MailBuilder(this.session);
    }

    public void send(Message message) throws MessagingException {
        Transport.send((Message)message);
    }

    public void send(String subject, String text, String ... recipients) throws MessagingException {
        try {
            this.compose().subject(subject).to(recipients).text(text).send();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

