/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.mail;

import com.axelor.common.StringUtils;
import com.axelor.mail.MailAccount;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;

public class SmtpAccount
implements MailAccount {
    private String host;
    private String port;
    private String user;
    private String password;
    private String channel;
    private int connectionTimeout = 60000;
    private int timeout = 60000;
    private Properties properties;
    private Session session;

    public SmtpAccount(String host, String port) {
        Preconditions.checkNotNull((Object)host, (Object)"host can't be null");
        this.host = host;
        this.port = port;
    }

    public SmtpAccount(String host, String port, String user, String password) {
        this(host, port);
        this.user = user;
        this.password = password;
    }

    public SmtpAccount(String host, String port, String user, String password, String channel) {
        this(host, port, user, password);
        this.channel = channel;
    }

    private Session init() {
        boolean authenticating = !StringUtils.isBlank((CharSequence)this.user);
        Properties props = new Properties();
        props.setProperty("mail.smtp.connectiontimeout", "" + this.connectionTimeout);
        props.setProperty("mail.smtp.timeout", "" + this.timeout);
        if (this.properties != null) {
            props.putAll((Map<?, ?>)this.properties);
        }
        props.setProperty("mail.smtp.host", this.host);
        props.setProperty("mail.smtp.port", this.port);
        props.setProperty("mail.smtp.auth", "" + authenticating);
        if (!StringUtils.isBlank((CharSequence)this.user)) {
            props.setProperty("mail.smtp.from", this.user);
        }
        if (!authenticating) {
            return Session.getInstance((Properties)props);
        }
        if ("starttls".equalsIgnoreCase(this.channel)) {
            props.setProperty("mail.smtp.starttls.enable", "true");
        }
        if ("ssl".equalsIgnoreCase(this.channel)) {
            props.setProperty("mail.smtp.ssl.enable", "true");
            props.setProperty("mail.smtp.socketFactory.port", this.port);
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        Authenticator authenticator = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(SmtpAccount.this.user, SmtpAccount.this.password);
            }
        };
        return Session.getInstance((Properties)props, (Authenticator)authenticator);
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public Session getSession() {
        if (this.session == null) {
            this.session = this.init();
        }
        return this.session;
    }
}

