/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.mail.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.mail.db.MailMessage;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Cacheable
@Table(name="MAIL_FLAGS", indexes={@Index(columnList="user_id"), @Index(columnList="message")})
public class MailFlags
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MAIL_FLAGS_SEQ")
    @SequenceGenerator(name="MAIL_FLAGS_SEQ", sequenceName="MAIL_FLAGS_SEQ", allocationSize=1)
    private Long id;
    @NotNull
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MailMessage message;
    private Boolean isStarred = Boolean.FALSE;
    private Boolean isRead = Boolean.FALSE;
    private Boolean isArchived = Boolean.FALSE;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public MailMessage getMessage() {
        return this.message;
    }

    public void setMessage(MailMessage message) {
        this.message = message;
    }

    public Boolean getIsStarred() {
        return this.isStarred == null ? Boolean.FALSE : this.isStarred;
    }

    public void setIsStarred(Boolean isStarred) {
        this.isStarred = isStarred;
    }

    public Boolean getIsRead() {
        return this.isRead == null ? Boolean.FALSE : this.isRead;
    }

    public void setIsRead(Boolean isRead) {
        this.isRead = isRead;
    }

    public Boolean getIsArchived() {
        return this.isArchived == null ? Boolean.FALSE : this.isArchived;
    }

    public void setIsArchived(Boolean isArchived) {
        this.isArchived = isArchived;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MailFlags)) {
            return false;
        }
        MailFlags other = (MailFlags)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("isStarred", (Object)this.getIsStarred()).add("isRead", (Object)this.getIsRead()).add("isArchived", (Object)this.getIsArchived()).omitNullValues().toString();
    }
}

