/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.mail.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.mail.db.MailAddress;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Cacheable
@Table(name="MAIL_FOLLOWER", indexes={@Index(columnList="user_id"), @Index(columnList="email")})
public class MailFollower
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MAIL_FOLLOWER_SEQ")
    @SequenceGenerator(name="MAIL_FOLLOWER_SEQ", sequenceName="MAIL_FOLLOWER_SEQ", allocationSize=1)
    private Long id;
    private Long relatedId = 0L;
    private String relatedModel;
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MailAddress email;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Long getRelatedId() {
        return this.relatedId == null ? 0L : this.relatedId;
    }

    public void setRelatedId(Long relatedId) {
        this.relatedId = relatedId;
    }

    public String getRelatedModel() {
        return this.relatedModel;
    }

    public void setRelatedModel(String relatedModel) {
        this.relatedModel = relatedModel;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public MailAddress getEmail() {
        return this.email;
    }

    public void setEmail(MailAddress email) {
        this.email = email;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MailFollower)) {
            return false;
        }
        MailFollower other = (MailFollower)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("relatedId", (Object)this.getRelatedId()).add("relatedModel", (Object)this.getRelatedModel()).omitNullValues().toString();
    }
}

