/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.mail.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.mail.db.MailAddress;
import com.axelor.mail.db.MailFlags;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="MAIL_MESSAGE", indexes={@Index(columnList="author"), @Index(columnList="email_from"), @Index(columnList="subject"), @Index(columnList="root"), @Index(columnList="parent")})
public class MailMessage
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MAIL_MESSAGE_SEQ")
    @SequenceGenerator(name="MAIL_MESSAGE_SEQ", sequenceName="MAIL_MESSAGE_SEQ", allocationSize=1)
    private Long id;
    @Widget(selection="message.type.selection")
    private String type;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User author;
    @JoinColumn(name="email_from")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MailAddress from;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MailAddress> recipients;
    @NameColumn
    private String subject;
    @Widget(multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String body;
    private String summary;
    @HashKey
    @Widget(help="Unique message identifier", readonly=true)
    @Column(unique=true)
    private String messageId;
    @Widget(title="Related document id")
    private Long relatedId = 0L;
    @Widget(title="Related document model")
    private String relatedModel;
    @Widget(title="Related document name")
    private String relatedName;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MailMessage root;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MailMessage parent;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parent", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MailMessage> replies;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="message", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MailFlags> flags;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public User getAuthor() {
        return this.author;
    }

    public void setAuthor(User author) {
        this.author = author;
    }

    public MailAddress getFrom() {
        return this.from;
    }

    public void setFrom(MailAddress from) {
        this.from = from;
    }

    public Set<MailAddress> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(Set<MailAddress> recipients) {
        this.recipients = recipients;
    }

    public void addRecipient(MailAddress item) {
        if (this.getRecipients() == null) {
            this.setRecipients(new HashSet<MailAddress>());
        }
        this.getRecipients().add(item);
    }

    public void removeRecipient(MailAddress item) {
        if (this.getRecipients() == null) {
            return;
        }
        this.getRecipients().remove(item);
    }

    public void clearRecipients() {
        if (this.getRecipients() != null) {
            this.getRecipients().clear();
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public Long getRelatedId() {
        return this.relatedId == null ? 0L : this.relatedId;
    }

    public void setRelatedId(Long relatedId) {
        this.relatedId = relatedId;
    }

    public String getRelatedModel() {
        return this.relatedModel;
    }

    public void setRelatedModel(String relatedModel) {
        this.relatedModel = relatedModel;
    }

    public String getRelatedName() {
        return this.relatedName;
    }

    public void setRelatedName(String relatedName) {
        this.relatedName = relatedName;
    }

    public MailMessage getRoot() {
        return this.root;
    }

    public void setRoot(MailMessage root) {
        this.root = root;
    }

    public MailMessage getParent() {
        return this.parent;
    }

    public void setParent(MailMessage parent) {
        this.parent = parent;
    }

    public List<MailMessage> getReplies() {
        return this.replies;
    }

    public void setReplies(List<MailMessage> replies) {
        this.replies = replies;
    }

    public void addReply(MailMessage item) {
        if (this.getReplies() == null) {
            this.setReplies(new ArrayList<MailMessage>());
        }
        this.getReplies().add(item);
        item.setParent(this);
    }

    public void removeReply(MailMessage item) {
        if (this.getReplies() == null) {
            return;
        }
        this.getReplies().remove(item);
    }

    public void clearReplies() {
        if (this.getReplies() != null) {
            this.getReplies().clear();
        }
    }

    public List<MailFlags> getFlags() {
        return this.flags;
    }

    public void setFlags(List<MailFlags> flags) {
        this.flags = flags;
    }

    public void addFlag(MailFlags item) {
        if (this.getFlags() == null) {
            this.setFlags(new ArrayList<MailFlags>());
        }
        this.getFlags().add(item);
        item.setMessage(this);
    }

    public void removeFlag(MailFlags item) {
        if (this.getFlags() == null) {
            return;
        }
        this.getFlags().remove(item);
    }

    public void clearFlags() {
        if (this.getFlags() != null) {
            this.getFlags().clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MailMessage)) {
            return false;
        }
        MailMessage other = (MailMessage)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getMessageId(), other.getMessageId());
    }

    public int hashCode() {
        return Objects.hash(-1747866064, this.getMessageId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("type", (Object)this.getType()).add("subject", (Object)this.getSubject()).add("summary", (Object)this.getSummary()).add("messageId", (Object)this.getMessageId()).add("relatedId", (Object)this.getRelatedId()).add("relatedModel", (Object)this.getRelatedModel()).add("relatedName", (Object)this.getRelatedName()).omitNullValues().toString();
    }
}

