/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.mail.db.repo;

import com.axelor.db.JpaRepository;
import com.axelor.mail.db.MailAddress;

public class MailAddressRepository
extends JpaRepository<MailAddress> {
    public MailAddressRepository() {
        super(MailAddress.class);
    }

    public MailAddress findByEmail(String email) {
        return (MailAddress)this.all().filter("self.address = :email").bind("email", email).cacheable().fetchOne();
    }

    public MailAddress findOrCreate(String email) {
        return this.findOrCreate(email, email);
    }

    public MailAddress findOrCreate(String email, String displayName) {
        MailAddress address = this.findByEmail(email);
        if (address == null) {
            address = new MailAddress();
            address.setAddress(email);
            address.setPersonal(displayName);
            this.save(address);
        }
        return address;
    }
}

