/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.mail.db.repo;

import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.common.StringUtils;
import com.axelor.db.EntityHelper;
import com.axelor.db.JPA;
import com.axelor.db.JpaRepository;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.mail.MailException;
import com.axelor.mail.db.MailAddress;
import com.axelor.mail.db.MailFlags;
import com.axelor.mail.db.MailMessage;
import com.axelor.mail.db.repo.MailAddressRepository;
import com.axelor.mail.db.repo.MailFlagsRepository;
import com.axelor.mail.service.MailService;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaAttachment;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.repo.MetaActionRepository;
import com.axelor.meta.db.repo.MetaAttachmentRepository;
import com.axelor.meta.schema.views.Selection;
import com.axelor.rpc.Resource;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.mail.internet.InternetAddress;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailMessageRepository
extends JpaRepository<MailMessage> {
    @Inject
    private MetaFiles files;
    @Inject
    private MailService mailService;
    @Inject
    private MetaAttachmentRepository attachmentRepo;
    @Inject
    private MetaActionRepository actionRepo;
    private Logger log = LoggerFactory.getLogger(MailMessageRepository.class);
    private static String mailHost;
    private static AtomicInteger mailId;

    public MailMessageRepository() {
        super(MailMessage.class);
    }

    public List<MailMessage> findAll(Model related, int limit, int offset) {
        return this.all().filter("self.relatedModel = ? AND self.relatedId = ?", EntityHelper.getEntityClass(related).getName(), related.getId()).order("-createdOn").fetch(limit, offset);
    }

    public long count(Model related) {
        return this.all().filter("self.relatedModel = ? AND self.relatedId = ?", EntityHelper.getEntityClass(related).getName(), related.getId()).count();
    }

    public Model findRelated(MailMessage message) {
        if (message.getRelatedId() == null) {
            return null;
        }
        try {
            Class<?> klass = Class.forName(message.getRelatedModel());
            return (Model)JPA.em().find(klass, (Object)message.getRelatedId());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void remove(MailMessage message) {
        List attachments = this.attachmentRepo.all().filter("self.objectId = ? AND self.objectName = ?", message.getId(), MailMessage.class.getName()).fetch();
        for (MetaAttachment attachment : attachments) {
            try {
                this.files.delete(attachment);
            }
            catch (IOException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        super.remove(message);
    }

    protected String generateMessageId(MailMessage entity) {
        if (mailHost == null) {
            InternetAddress addr = InternetAddress.getLocalAddress(null);
            String string = mailHost = addr == null ? "javamailuser@localhost" : addr.getAddress();
            if (mailHost.indexOf("@") > 0) {
                mailHost = mailHost.substring(mailHost.lastIndexOf("@"));
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        builder.append(builder.hashCode()).append(".");
        builder.append(mailId.getAndIncrement()).append(".");
        builder.append(System.currentTimeMillis());
        builder.append(mailHost);
        builder.append(">");
        return builder.toString();
    }

    @Override
    public MailMessage save(MailMessage entity) {
        MailMessage root;
        if (entity.getParent() == null && entity.getRelatedId() != null) {
            MailMessage parent = (MailMessage)this.all().filter("self.parent is null AND self.relatedId = :id AND self.relatedModel = :model").bind("id", entity.getRelatedId()).bind("model", entity.getRelatedModel()).order("id").cacheable().autoFlush(false).fetchOne();
            entity.setParent(parent);
        }
        if ((root = entity.getRoot()) == null) {
            root = entity.getParent();
        }
        if (root != null && root.getRoot() != null) {
            root = root.getRoot();
        }
        entity.setRoot(root);
        if (root != null && AuthUtils.getUser() != null) {
            Beans.get(MailFlagsRepository.class).all().filter("self.message.id = :mid and self.user.id != :uid").bind("mid", root.getId()).bind("uid", AuthUtils.getUser().getId()).update("isRead", false);
        }
        boolean isNew = entity.getId() == null;
        boolean isNotification = "notification".equals(entity.getType());
        if (entity.getMessageId() == null) {
            entity.setMessageId(this.generateMessageId(entity));
        }
        MailMessage saved = super.save(entity);
        if (isNotification && isNew) {
            this.email(saved);
        }
        return saved;
    }

    public void email(MailMessage message) {
        try {
            this.mailService.send(message);
        }
        catch (MailException e) {
            this.log.error("Error sending mail: " + e.getMessage(), (Throwable)e);
        }
    }

    @Transactional
    public MailMessage post(Model entity, MailMessage message, List<MetaFile> files) {
        Mapper mapper = Mapper.of(EntityHelper.getEntityClass(entity));
        MailFlags flags = new MailFlags();
        message.setRelatedId(entity.getId());
        message.setRelatedModel(EntityHelper.getEntityClass(entity).getName());
        message.setAuthor(AuthUtils.getUser());
        flags.setMessage(message);
        flags.setUser(AuthUtils.getUser());
        flags.setIsRead(Boolean.TRUE);
        message.addFlag(flags);
        try {
            message.setRelatedName(mapper.getNameField().get(entity).toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (message.getRecipients() != null) {
            HashSet<MailAddress> recipients = new HashSet<MailAddress>();
            MailAddressRepository addresses = Beans.get(MailAddressRepository.class);
            for (MailAddress address : message.getRecipients()) {
                recipients.add(addresses.findOrCreate(address.getAddress(), address.getPersonal()));
            }
            message.clearRecipients();
            message.setRecipients(recipients);
        }
        message = this.save(message);
        if (files == null || files.isEmpty()) {
            this.email(message);
            return message;
        }
        MetaAttachmentRepository repo = Beans.get(MetaAttachmentRepository.class);
        for (MetaFile file : files) {
            MetaAttachment attachment = new MetaAttachment();
            attachment.setObjectId(message.getId());
            attachment.setObjectName(message.getClass().getName());
            attachment.setMetaFile(file);
            repo.save(attachment);
        }
        this.email(message);
        return message;
    }

    public List<MetaAttachment> findAttachments(MailMessage message) {
        if (message == null || message.getId() == null) {
            return new ArrayList<MetaAttachment>();
        }
        MetaAttachmentRepository repoAttachments = Beans.get(MetaAttachmentRepository.class);
        return repoAttachments.all().filter("self.objectId = ? AND self.objectName = ?", message.getId(), EntityHelper.getEntityClass(message).getName()).fetch();
    }

    private String updateBody(MailMessage message) throws Exception {
        String body = message.getBody();
        if (!"notification".equals(message.getType()) || message.getRelatedModel() == null) {
            return body;
        }
        if (message.getBody() == null || message.getBody().trim().charAt(0) != '{') {
            return body;
        }
        Mapper mapper = Mapper.of(Class.forName(message.getRelatedModel()));
        ObjectMapper json = Beans.get(ObjectMapper.class);
        Map bodyData = (Map)json.readValue(body, Map.class);
        ArrayList<Map> values = new ArrayList<Map>();
        for (Map item : (List)bodyData.get("tracks")) {
            values.add(item);
            Property property = mapper.getProperty((String)item.get("name"));
            if (property == null || StringUtils.isBlank((CharSequence)property.getSelection())) continue;
            Selection.Option d1 = MetaStore.getSelectionItem(property.getSelection(), (String)item.get("value"));
            Selection.Option d2 = MetaStore.getSelectionItem(property.getSelection(), (String)item.get("oldValue"));
            item.put("displayValue", d1 == null ? null : d1.getLocalizedTitle());
            item.put("oldDisplayValue", d2 == null ? null : d2.getLocalizedTitle());
        }
        bodyData.put("tracks", values);
        return json.writeValueAsString((Object)bodyData);
    }

    public Map<String, Object> details(MailMessage message) {
        String[] fields = new String[]{"id", "type", "subject", "body", "summary", "relatedId", "relatedModel", "relatedName"};
        Map<String, Object> details = Resource.toMap(message, fields);
        ArrayList<Map<String, Object>> files = new ArrayList<Map<String, Object>>();
        MailService mailService = Beans.get(MailService.class);
        MailFlagsRepository repoFlags = Beans.get(MailFlagsRepository.class);
        MailFlags flags = repoFlags.findBy(message, AuthUtils.getUser());
        List<MetaAttachment> attachments = this.findAttachments(message);
        for (MetaAttachment attachment : attachments) {
            Map<String, Object> fileInfo = Resource.toMapCompact(attachment.getMetaFile());
            fileInfo.put("fileIcon", Beans.get(MetaFiles.class).fileTypeIcon(attachment.getMetaFile()));
            files.add(fileInfo);
        }
        if (flags != null) {
            details.put("$flags", Resource.toMap(flags, "isRead", "isStarred", "isArchived"));
        }
        String eventType = message.getType();
        String eventText = I18n.get("updated document");
        if ("comment".equals(eventType) || "email".equals(eventType)) {
            eventText = I18n.get("added comment");
            details.put("$canDelete", message.getCreatedBy() == AuthUtils.getUser());
        }
        MailAddress email = message.getFrom();
        User user = message.getAuthor();
        Model author = user;
        if (author == null && email != null) {
            author = mailService.resolve(email.getAddress());
        }
        if (author != null) {
            String authorModel = EntityHelper.getEntityClass(author).getName();
            MetaAction authorAction = (MetaAction)this.actionRepo.all().filter("self.type = 'action-view' and self.model = ?", authorModel).fetchOne();
            if (authorAction != null) {
                details.put("$authorAction", authorAction.getName());
            }
            details.put("$authorModel", authorModel);
        }
        if (user != null && user.getImage() != null) {
            details.put("$avatar", "ws/rest/" + User.class.getName() + "/" + user.getId() + "/image/download?image=true&v=" + user.getVersion());
        }
        try {
            details.put("body", this.updateBody(message));
        }
        catch (Exception exception) {
            // empty catch block
        }
        details.put("$from", Resource.toMap(email, "address", "personal"));
        details.put("$author", Resource.toMapCompact(author));
        details.put("$files", files);
        details.put("$eventType", eventType);
        details.put("$eventText", eventText);
        details.put("$eventTime", message.getCreatedOn());
        return details;
    }

    static {
        mailId = new AtomicInteger();
    }
}

