/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.mail.web;

import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.JpaSupport;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.axelor.mail.db.MailFlags;
import com.axelor.mail.db.MailMessage;
import com.axelor.mail.db.repo.MailFlagsRepository;
import com.axelor.mail.db.repo.MailFollowerRepository;
import com.axelor.mail.db.repo.MailMessageRepository;
import com.axelor.meta.CallMethod;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.axelor.rpc.Response;
import com.axelor.team.db.Team;
import com.axelor.team.db.repo.TeamRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.TypedQuery;

public class MailController
extends JpaSupport {
    private static final String SQL_UNREAD = "SELECT mm FROM MailMessage mm LEFT JOIN MailFollower f ON f.relatedId = mm.relatedId and f.relatedModel = mm.relatedModel LEFT JOIN MailFlags g ON g.user = f.user AND g.message = mm.id WHERE (mm.parent IS NULL) AND  (f.user.id = :uid AND f.archived = false) AND (g.isRead IS NULL OR g.isRead = false) ORDER BY CASE WHEN mm.replies IS EMPTY THEN mm.createdOn ELSE (SELECT MAX(reply.createdOn) FROM mm.replies reply) END DESC";
    private static final String SQL_SUBSCRIBERS = "SELECT DISTINCT(u) FROM User u LEFT JOIN u.group g LEFT JOIN u.roles r LEFT JOIN g.roles gr WHERE (u.id NOT IN (SELECT fu.id FROM MailFollower f LEFT JOIN f.user fu WHERE f.relatedId = :id AND f.relatedModel = :model)) AND ((u.id IN (SELECT mu.id FROM Team m LEFT JOIN m.members mu WHERE m.id = :id)) OR \t(r.id IN (SELECT mr.id FROM Team m LEFT JOIN m.roles mr WHERE m.id = :id)) OR  (gr.id IN (SELECT mr.id FROM Team m LEFT JOIN m.roles mr WHERE m.id = :id)))";
    private static final String SQL_INBOX = "SELECT mm FROM MailMessage mm LEFT JOIN MailFollower f ON f.relatedId = mm.relatedId and f.relatedModel = mm.relatedModel LEFT JOIN MailFlags g ON g.user = f.user AND g.message = mm.id WHERE (mm.parent IS NULL) AND  (f.user.id = :uid AND f.archived = false) AND (g.isRead IS NULL OR g.isRead = false OR g.isArchived = false) ORDER BY CASE WHEN mm.replies IS EMPTY THEN mm.createdOn ELSE (SELECT MAX(reply.createdOn) FROM mm.replies reply) END DESC";
    private static final String SQL_IMPORTANT = "SELECT mm FROM MailMessage mm LEFT JOIN MailFollower f ON f.relatedId = mm.relatedId and f.relatedModel = mm.relatedModel LEFT JOIN MailFlags g ON g.user = f.user AND g.message = mm.id WHERE (mm.parent IS NULL) AND  (f.user.id = :uid AND f.archived = false) AND (g.isStarred = true AND g.isArchived = false) ORDER BY CASE WHEN mm.replies IS EMPTY THEN mm.createdOn ELSE (SELECT MAX(reply.createdOn) FROM mm.replies reply) END DESC";
    private static final String SQL_ARCHIVE = "SELECT mm FROM MailMessage mm LEFT JOIN MailFollower f ON f.relatedId = mm.relatedId and f.relatedModel = mm.relatedModel LEFT JOIN MailFlags g ON g.user = f.user AND g.message = mm.id WHERE (mm.parent IS NULL) AND  (f.user.id = :uid AND f.archived = false) AND (g.isArchived = true) ORDER BY CASE WHEN mm.replies IS EMPTY THEN mm.createdOn ELSE (SELECT MAX(reply.createdOn) FROM mm.replies reply) END DESC";
    @Inject
    private MailMessageRepository messages;

    public void countMail(ActionRequest request, ActionResponse response) {
        HashMap<String, Long> value = new HashMap<String, Long>();
        value.put("total", this.countMessages(SQL_INBOX));
        value.put("unread", this.countMessages(SQL_UNREAD));
        response.setValue("mail", value);
        response.setStatus(Response.STATUS_SUCCESS);
    }

    public void countUnread(ActionRequest request, ActionResponse response) {
        response.setValue("unread", this.countMessages(SQL_UNREAD));
        response.setStatus(Response.STATUS_SUCCESS);
    }

    public void unread(ActionRequest request, ActionResponse response) {
        List<Object> all = this.find(SQL_UNREAD, request.getOffset(), request.getLimit());
        Long total = this.countMessages(SQL_UNREAD);
        response.setData(all);
        response.setOffset(request.getOffset());
        response.setTotal(total);
    }

    public void inbox(ActionRequest request, ActionResponse response) {
        List<Object> all = this.find(SQL_INBOX, request.getOffset(), request.getLimit());
        Long total = this.countMessages(SQL_INBOX);
        response.setData(all);
        response.setOffset(request.getOffset());
        response.setTotal(total);
    }

    public void important(ActionRequest request, ActionResponse response) {
        List<Object> all = this.find(SQL_IMPORTANT, request.getOffset(), request.getLimit());
        Long total = this.countMessages(SQL_IMPORTANT);
        response.setData(all);
        response.setOffset(request.getOffset());
        response.setTotal(total);
    }

    public void archived(ActionRequest request, ActionResponse response) {
        List<Object> all = this.find(SQL_ARCHIVE, request.getOffset(), request.getLimit());
        Long total = this.countMessages(SQL_ARCHIVE);
        response.setData(all);
        response.setOffset(request.getOffset());
        response.setTotal(total);
    }

    public void related(ActionRequest request, ActionResponse response) {
        if (request.getRecords() == null || request.getRecords().isEmpty()) {
            return;
        }
        Model related = (Model)request.getRecords().get(0);
        List<MailMessage> all = this.messages.findAll(related, request.getLimit(), request.getOffset());
        Long count = this.messages.count(related);
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        for (MailMessage message : all) {
            data.add(this.messages.details(message));
        }
        response.setData(data);
        response.setOffset(request.getOffset());
        response.setTotal(count);
    }

    public void replies(ActionRequest request, ActionResponse response) {
        if (request.getRecords() == null || request.getRecords().isEmpty()) {
            return;
        }
        MailMessage parent = (MailMessage)this.messages.find((Long)request.getRecords().get(0));
        List<MailMessage> found = this.findChildren(parent);
        ArrayList<Map<String, Object>> all = new ArrayList<Map<String, Object>>();
        for (MailMessage message : found) {
            Map<String, Object> details = this.messages.details(message);
            details.put("$thread", true);
            all.add(details);
        }
        response.setData(all);
        response.setStatus(ActionResponse.STATUS_SUCCESS);
    }

    public void autoSubscribe(ActionRequest request, ActionResponse response) {
        MailFollowerRepository followers = Beans.get(MailFollowerRepository.class);
        TeamRepository teams = Beans.get(TeamRepository.class);
        Team team = request.getContext().asType(Team.class);
        if (team == null || team.getId() == null) {
            return;
        }
        TypedQuery query = this.getEntityManager().createQuery(SQL_SUBSCRIBERS, User.class);
        query.setParameter("id", (Object)team.getId());
        query.setParameter("model", (Object)Team.class.getName());
        List users = query.getResultList();
        Team entity = (Team)teams.find(team.getId());
        for (User user : users) {
            followers.follow((Model)entity, user);
        }
        response.setStatus(ActionResponse.STATUS_SUCCESS);
    }

    public void follow(ActionRequest request, ActionResponse response) {
        Context ctx = request.getContext();
        Long id = (Long)ctx.get("id");
        Model entity = (Model)this.getEntityManager().find(ctx.getContextClass(), (Object)id);
        MailFollowerRepository followers = Beans.get(MailFollowerRepository.class);
        followers.follow(entity, AuthUtils.getUser());
        response.setValue("_following", true);
        response.setStatus(ActionResponse.STATUS_SUCCESS);
    }

    public void unfollow(ActionRequest request, ActionResponse response) {
        Context ctx = request.getContext();
        Long id = (Long)ctx.get("id");
        Model entity = (Model)this.getEntityManager().find(ctx.getContextClass(), (Object)id);
        MailFollowerRepository followers = Beans.get(MailFollowerRepository.class);
        followers.unfollow(entity, AuthUtils.getUser());
        response.setValue("_following", false);
        response.setStatus(ActionResponse.STATUS_SUCCESS);
    }

    @CallMethod
    public String inboxMenuTag() {
        Long total = this.countMessages(SQL_INBOX);
        Long unread = this.countMessages(SQL_UNREAD);
        if (total == null) {
            return null;
        }
        if (unread == null) {
            unread = 0L;
        }
        return String.format("%s/%s", unread, total);
    }

    private List<MailMessage> findChildren(MailMessage message) {
        ArrayList<MailMessage> all = new ArrayList<MailMessage>();
        if (message.getReplies() == null) {
            return all;
        }
        for (MailMessage msg : this.messages.all().filter("self.parent.id = ?", message.getId()).order("-createdOn").fetch()) {
            all.add(msg);
            all.addAll(this.findChildren(msg));
        }
        return all;
    }

    private Long countMessages(String queryString) {
        User user = AuthUtils.getUser();
        if (user == null) {
            return 0L;
        }
        String countString = queryString.replace("SELECT mm FROM MailMessage mm", "SELECT COUNT(mm.id) FROM MailMessage mm").replaceFirst("\\s*ORDER BY.*$", "");
        TypedQuery query = this.getEntityManager().createQuery(countString, Long.class);
        query.setParameter("uid", (Object)user.getId());
        try {
            return (Long)query.getSingleResult();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    private List<Object> find(String queryString, int offset, int limit) {
        User user = AuthUtils.getUser();
        if (user == null) {
            return Collections.emptyList();
        }
        TypedQuery query = this.getEntityManager().createQuery(queryString, MailMessage.class);
        MailFlagsRepository flagsRepo = Beans.get(MailFlagsRepository.class);
        query.setParameter("uid", (Object)user.getId());
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        List found = query.getResultList();
        ArrayList<Object> all = new ArrayList<Object>();
        for (MailMessage message : found) {
            Map<String, Object> details = this.messages.details(message);
            List replies = this.messages.all().filter("self.root.id = ?", message.getId()).order("-createdOn").fetch();
            ArrayList<Map<String, Object>> unread = new ArrayList<Map<String, Object>>();
            for (MailMessage reply : replies) {
                MailFlags flags = flagsRepo.findBy(reply, AuthUtils.getUser());
                if (flags != null && flags.getIsRead() != Boolean.FALSE) continue;
                unread.add(this.messages.details(reply));
            }
            details.put("$name", details.get("relatedName"));
            details.put("$thread", true);
            details.put("$numReplies", replies.size());
            details.put("$children", unread);
            details.put("$hasMore", replies.size() > unread.size());
            all.add(details);
        }
        return all;
    }
}

