/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta;

import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.QueryBinder;
import com.axelor.event.Event;
import com.axelor.event.NamedLiteral;
import com.axelor.events.PostAction;
import com.axelor.events.PreAction;
import com.axelor.inject.Beans;
import com.axelor.meta.ActionExecutor;
import com.axelor.meta.CallMethod;
import com.axelor.meta.MetaStore;
import com.axelor.meta.schema.actions.Action;
import com.axelor.meta.schema.actions.ActionGroup;
import com.axelor.meta.schema.actions.ActionMethod;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.axelor.rpc.ContextEntity;
import com.axelor.rpc.Resource;
import com.axelor.script.CompositeScriptHelper;
import com.axelor.script.ScriptHelper;
import com.axelor.text.Templates;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.google.common.io.CharStreams;
import com.google.inject.servlet.RequestScoped;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.persistence.Query;
import javax.script.Bindings;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class ActionHandler {
    private final Logger log = LoggerFactory.getLogger(ActionHandler.class);
    private final ActionRequest request;
    private final Event<PreAction> preActionEvent;
    private final Event<PostAction> postActionEvent;
    private final Context context;
    private final Bindings bindings;
    private final ScriptHelper scriptHelper;
    private final Pattern pattern = Pattern.compile("^\\s*(select\\[\\]|select|action|call|eval):\\s*(.*)");
    private static final Escaper STRING_ESCAPER = Escapers.builder().addEscape('\"', "\\\"").build();
    private static final String KEY_VALUES = "values";
    private static final String KEY_ATTRS = "attrs";
    private static final String KEY_VALUE = "value";

    @Deprecated
    public ActionHandler(ActionRequest request) {
        this(request, Beans.get(ActionExecutor.class));
    }

    private ActionHandler(ActionRequest request, ActionExecutor actionExecutor) {
        this(request, actionExecutor.getPreActionEvent(), actionExecutor.getPostActionEvent());
    }

    ActionHandler(ActionRequest request, Event<PreAction> preActionEvent, Event<PostAction> postActionEvent) {
        this.request = request;
        this.preActionEvent = preActionEvent;
        this.postActionEvent = postActionEvent;
        this.context = request.getContext();
        this.scriptHelper = new CompositeScriptHelper(this.context);
        this.bindings = this.scriptHelper.getBindings();
        this.bindings.put("__me__", (Object)this);
    }

    public void firePreEvent(String name) {
        this.preActionEvent.select(new Annotation[]{NamedLiteral.of(name)}).fire(new PreAction(name, this.context));
    }

    public PostAction firePostEvent(String name, Object result) {
        PostAction event = new PostAction(name, this.context, result);
        this.postActionEvent.select(new Annotation[]{NamedLiteral.of(name)}).fire(event);
        return event;
    }

    public Context getContext() {
        return this.context;
    }

    public ActionRequest getRequest() {
        return this.request;
    }

    public Object evaluate(String expression) {
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return null;
        }
        String expr = expression.trim();
        if (expr.startsWith("#{") && expr.endsWith("}")) {
            return this.handleScript(expr);
        }
        String kind = null;
        Matcher matcher = this.pattern.matcher(expression);
        if (!matcher.matches()) {
            return expr;
        }
        kind = matcher.group(1);
        expr = matcher.group(2);
        if ("eval".equals(kind)) {
            return this.handleScript(expr);
        }
        if ("action".equals(kind)) {
            return this.handleAction(expr);
        }
        if ("call".equals(kind)) {
            return this.handleCall(expr);
        }
        if ("select".equals(kind)) {
            return this.handleSelectOne(expr);
        }
        if ("select[]".equals(kind)) {
            return this.handleSelectAll(expr);
        }
        return expr;
    }

    public Object call(String className, String method) {
        ActionResponse response = new ActionResponse();
        try {
            Class<?> klass = Class.forName(className);
            Method m = klass.getMethod(method, ActionRequest.class, ActionResponse.class);
            Object obj = Beans.get(klass);
            m.invoke(obj, this.request, response);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            response.setException(e);
        }
        return response;
    }

    public Object rpc(String className, String methodCall) {
        Pattern pattern = Pattern.compile("(\\w+)\\((.*?)\\)");
        Matcher matcher = pattern.matcher(methodCall);
        if (!matcher.matches()) {
            return null;
        }
        String methodName = matcher.group(1);
        String methodArgs = matcher.group(2);
        try {
            Class<?> klass = Class.forName(className);
            List methods = Arrays.stream(klass.getMethods()).filter(m -> m.getName().equals(methodName)).collect(Collectors.toList());
            if (methods.size() == 0) {
                throw new IllegalArgumentException(new NoSuchMethodException(String.format("%s.%s()", className, methodName)));
            }
            if (methods.size() == 1 || StringUtils.isBlank((CharSequence)methodArgs)) {
                Method method2 = (Method)methods.get(0);
                if (method2.getAnnotation(CallMethod.class) == null) {
                    throw new IllegalArgumentException(String.format("Action not allowed: %s:%s", className, methodCall));
                }
            } else {
                Object validator = new ByteBuddy().subclass(klass).method((ElementMatcher)ElementMatchers.named((String)methodName)).intercept((Implementation)InvocationHandlerAdapter.of((proxy, method, args) -> {
                    if (method.getAnnotation(CallMethod.class) == null) {
                        throw new IllegalArgumentException(String.format("Action not allowed: %s:%s", className, methodCall));
                    }
                    return null;
                })).make().load(klass.getClassLoader()).getLoaded().newInstance();
                this.scriptHelper.call(validator, methodCall);
            }
            Object object = Beans.get(klass);
            return this.scriptHelper.call(object, methodCall);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String template(Templates engine, Reader template) throws IOException {
        return engine.fromText(CharStreams.toString((Readable)template)).make(this.bindings).render();
    }

    private Query select(String query, Object ... params) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)query) ? 1 : 0) != 0);
        if (!query.toLowerCase().startsWith("select ")) {
            query = "SELECT " + query;
        }
        Query q = JPA.em().createQuery(query);
        QueryBinder.of(q).bind(this.bindings, params);
        return q;
    }

    public Object selectOne(String query, Object ... params) {
        Query q = this.select(query, params);
        q.setMaxResults(1);
        try {
            return q.getResultList().get(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object selectAll(String query, Object ... params) {
        try {
            return this.select(query, params).getResultList();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object selectOne(String query) {
        return this.selectOne(query, new Object[0]);
    }

    public Object selectAll(String query) {
        return this.selectAll(query, new Object[0]);
    }

    public Object search(Class<?> entityClass, String filter, Map params) {
        filter = this.makeMethodCall(String.format("__repo__(%s).all().filter", entityClass.getSimpleName()), filter);
        com.axelor.db.Query q = (com.axelor.db.Query)this.handleScript(filter);
        q = q.bind(this.bindings);
        q = q.bind(params);
        return q.fetchOne();
    }

    private String makeMethodCall(String method, String expression) {
        if (!(expression = expression.trim()).startsWith("(")) {
            if (!expression.matches("('|\")")) {
                expression = "\"" + STRING_ESCAPER.escape(expression) + "\"";
            }
            expression = "(" + expression + ")";
        }
        return "#{" + method + expression + "}";
    }

    private Object handleSelectOne(String expression) {
        expression = this.makeMethodCall("__me__.selectOne", expression);
        return this.handleScript(expression);
    }

    private Object handleSelectAll(String expression) {
        expression = this.makeMethodCall("__me__.selectAll", expression);
        return this.handleScript(expression);
    }

    private Object handleScript(String expression) {
        return this.scriptHelper.eval(expression);
    }

    private Object handleAction(String expression) {
        Action action = MetaStore.getAction(expression);
        if (action == null) {
            this.log.debug("no such action found: {}", (Object)expression);
            return null;
        }
        return action.execute(this);
    }

    private Object handleCall(String expression) {
        if (Strings.isNullOrEmpty((String)expression)) {
            return null;
        }
        String[] parts = expression.split("\\:");
        if (parts.length != 2) {
            this.log.error("Invalid call expression: ", (Object)expression);
            return null;
        }
        ActionMethod action = new ActionMethod();
        ActionMethod.Call call = new ActionMethod.Call();
        call.setController(parts[0]);
        call.setMethod(parts[1]);
        action.setCall(call);
        action.setName(expression);
        return action.execute(this);
    }

    private Object toCompact(Object item) {
        Model bean;
        if (item == null) {
            return null;
        }
        if (item instanceof Collection) {
            return Collections2.transform((Collection)((Collection)item), (Function)new Function<Object, Object>(){

                public Object apply(Object input) {
                    return ActionHandler.this.toCompact(input);
                }
            });
        }
        if (item instanceof Model && (bean = (Model)item).getId() != null && JPA.em().contains((Object)bean)) {
            return Resource.toMapCompact(bean);
        }
        return item;
    }

    private Object process(Object data) {
        if (data == null || data instanceof ContextEntity) {
            return data;
        }
        if (data instanceof Collection) {
            ArrayList<Object> items = new ArrayList<Object>();
            for (Object item : (Collection)data) {
                items.add(this.process(item));
            }
            return items;
        }
        if (data instanceof Map) {
            Map values;
            HashMap item = new HashMap((Map)data);
            if (item.containsKey(KEY_VALUES) && item.get(KEY_VALUES) instanceof Map && !(item.get(KEY_VALUES) instanceof ContextEntity)) {
                values = (Map)item.get(KEY_VALUES);
                for (String key : values.keySet()) {
                    Object value = values.get(key);
                    if (!(value instanceof Model)) continue;
                    values.put(key, this.toCompact(value));
                }
            }
            if (item.containsKey(KEY_ATTRS) && item.get(KEY_ATTRS) instanceof Map && !(item.get(KEY_ATTRS) instanceof ContextEntity)) {
                values = (Map)item.get(KEY_ATTRS);
                for (String key : values.keySet()) {
                    Map attrs = (Map)values.get(key);
                    if (!attrs.containsKey(KEY_VALUE)) continue;
                    attrs.put(KEY_VALUE, this.toCompact(attrs.get(KEY_VALUE)));
                }
            }
            return item;
        }
        return data;
    }

    public ActionResponse execute() {
        ActionResponse response = new ActionResponse();
        String name = this.request.getAction();
        if (name == null) {
            throw new NullPointerException("no action provided");
        }
        String[] names = name.split(",");
        ActionGroup action = new ActionGroup();
        for (String item : names) {
            action.addAction(item);
        }
        Object data = action.wrap(this);
        if (data instanceof ActionResponse) {
            return (ActionResponse)data;
        }
        response.setData(this.process(data));
        response.setStatus(ActionResponse.STATUS_SUCCESS);
        return response;
    }
}

