/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta;

import com.axelor.app.AppSettings;
import com.axelor.common.StringUtils;
import com.axelor.db.EntityHelper;
import com.axelor.db.Model;
import com.axelor.db.tenants.TenantResolver;
import com.axelor.dms.db.DMSFile;
import com.axelor.dms.db.repo.DMSFileRepository;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaAttachment;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.repo.MetaAttachmentRepository;
import com.axelor.meta.db.repo.MetaFileRepository;
import com.google.common.base.Preconditions;
import com.google.inject.persist.Transactional;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import org.apache.tika.Tika;

public class MetaFiles {
    private static final String DEFAULT_UPLOAD_PATH = "{java.io.tmpdir}/axelor/attachments";
    private static final Path UPLOAD_PATH = Paths.get(AppSettings.get().get("file.upload.dir", "{java.io.tmpdir}/axelor/attachments"), new String[0]);
    private static final String UPLOAD_NAME_PATTERN = AppSettings.get().get("file.upload.filename.pattern", "auto");
    private static final String UPLOAD_NAME_PATTERN_AUTO = "auto";
    private static final CopyOption[] COPY_OPTIONS = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES};
    private static final CopyOption[] MOVE_OPTIONS = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
    private static final long TEMP_THRESHOLD = 86400000L;
    private static final Object lock = new Object();
    private static final List<Pattern> WHITELIST_PATTERNS = AppSettings.get().getList("file.upload.whitelist.pattern", Pattern::compile);
    private static final List<Pattern> BLACKLIST_PATTERNS = AppSettings.get().getList("file.upload.blacklist.pattern", Pattern::compile);
    private static final List<MimeType> WHITELIST_TYPES = MetaFiles.getMimeTypes("file.upload.whitelist.types");
    private static final List<MimeType> BLACKLIST_TYPES = MetaFiles.getMimeTypes("file.upload.blacklist.types");
    private static final Tika TIKA = new Tika();
    private MetaFileRepository filesRepo;

    @Inject
    public MetaFiles(MetaFileRepository filesRepo) {
        this.filesRepo = filesRepo;
    }

    private static List<MimeType> getMimeTypes(String key) {
        return AppSettings.get().getList(key, s -> {
            try {
                return new MimeType(s);
            }
            catch (MimeTypeParseException e) {
                throw new RuntimeException("Invalid file type: " + s + " for '" + key + "'");
            }
        });
    }

    private static Path getUploadPath() {
        String tenantId = TenantResolver.currentTenantIdentifier();
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            return UPLOAD_PATH;
        }
        return UPLOAD_PATH.resolve(tenantId);
    }

    private static Path getUploadPath(String fileName) {
        Path uploadPath = MetaFiles.getUploadPath().normalize();
        Path targetPath = uploadPath.resolve(fileName).normalize();
        if (targetPath.startsWith(uploadPath) && !targetPath.equals(uploadPath)) {
            return targetPath;
        }
        throw new IllegalArgumentException("Invalid file name: " + fileName);
    }

    private static Path getTempPath() {
        return MetaFiles.getUploadPath("tmp");
    }

    private static Path getTempPath(String fileName) {
        return MetaFiles.getTempPath().resolve(fileName);
    }

    public static Path getPath(MetaFile file) {
        Preconditions.checkNotNull((Object)file, (Object)"file instance can't be null");
        return MetaFiles.getUploadPath(file.getFilePath());
    }

    public static Path getPath(String filePath) {
        Preconditions.checkNotNull((Object)filePath, (Object)"file path can't be null");
        return MetaFiles.getUploadPath(filePath);
    }

    public static void checkPath(String filePath) {
        boolean allowed;
        boolean blocked;
        Preconditions.checkNotNull((Object)filePath, (Object)"file path can't be null");
        boolean bl = blocked = BLACKLIST_PATTERNS.isEmpty() ? false : BLACKLIST_PATTERNS.stream().map(p -> p.matcher(filePath)).filter(m -> m.find()).findFirst().isPresent();
        if (blocked) {
            throw new IllegalArgumentException("File name is not allowed: " + filePath);
        }
        boolean bl2 = allowed = WHITELIST_PATTERNS.isEmpty() ? true : WHITELIST_PATTERNS.stream().map(p -> p.matcher(filePath)).filter(m -> m.find()).findFirst().isPresent();
        if (!allowed) {
            throw new IllegalArgumentException("File name is not allowed: " + filePath);
        }
        MetaFiles.getUploadPath(filePath);
    }

    public static void checkType(String fileType) {
        boolean allowed;
        boolean blocked;
        MimeType mimeType;
        if (StringUtils.isBlank((CharSequence)fileType)) {
            return;
        }
        try {
            mimeType = new MimeType(fileType);
        }
        catch (MimeTypeParseException e) {
            return;
        }
        boolean bl = blocked = BLACKLIST_TYPES.isEmpty() ? false : BLACKLIST_TYPES.stream().filter(m -> m.match(mimeType)).findFirst().isPresent();
        if (blocked) {
            throw new IllegalArgumentException("File type is not allowed: " + fileType);
        }
        boolean bl2 = allowed = WHITELIST_TYPES.isEmpty() ? true : WHITELIST_TYPES.stream().filter(m -> m.match(mimeType)).findFirst().isPresent();
        if (!allowed) {
            throw new IllegalArgumentException("File type is not allowed: " + fileType);
        }
    }

    public static void checkType(File file) {
        Preconditions.checkNotNull((Object)file, (Object)"file can't be null");
        String type = null;
        try {
            type = Files.probeContentType(file.toPath());
            if (type == null) {
                type = TIKA.detect(file);
            }
        }
        catch (IOException e1) {
            throw new IllegalArgumentException("File is not accessible: " + file.getName());
        }
        MetaFiles.checkType(type);
    }

    public static Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) throws IOException {
        Path tmp = MetaFiles.getTempPath();
        Files.createDirectories(tmp, new FileAttribute[0]);
        return Files.createTempFile(tmp, prefix, suffix, attrs);
    }

    public static Path findTempFile(String name) {
        return MetaFiles.getTempPath(name);
    }

    private String getTargetName(String fileName) {
        if (UPLOAD_NAME_PATTERN.equals(UPLOAD_NAME_PATTERN_AUTO)) {
            return fileName;
        }
        LocalDate date = LocalDate.now();
        String targetName = UPLOAD_NAME_PATTERN;
        if (targetName.indexOf("{A}") > -1) {
            targetName = targetName.replace("{A}", fileName.substring(0, 1).toUpperCase());
        }
        if (targetName.indexOf("{AA}") > -1) {
            targetName = targetName.replace("{AA}", fileName.substring(0, Math.min(2, fileName.length())).toUpperCase());
        }
        if (targetName.indexOf("{AAA}") > -1) {
            targetName = targetName.replace("{AAA}", fileName.substring(0, Math.min(3, fileName.length())).toUpperCase());
        }
        targetName = targetName.replace("{year}", "" + date.getYear());
        targetName = targetName.replace("{month}", "" + date.getMonthValue());
        targetName = targetName.replace("{day}", "" + date.getDayOfMonth());
        targetName = targetName.replace("{name}", fileName);
        return targetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path getNextPath(String fileName) {
        Object object = lock;
        synchronized (object) {
            int dotIndex = fileName.lastIndexOf(46);
            int counter = 1;
            String fileNameBase = fileName;
            String fileNameExt = "";
            if (dotIndex > -1) {
                fileNameExt = fileName.substring(dotIndex);
                fileNameBase = fileName.substring(0, dotIndex);
            }
            String targetName = this.getTargetName(fileName);
            Path target = MetaFiles.getUploadPath(targetName);
            Path targetDir = target.getParent();
            while (Files.exists(target, new LinkOption[0])) {
                targetName = fileNameBase + " (" + counter++ + ")" + fileNameExt;
                target = targetDir.resolve(targetName);
            }
            return target;
        }
    }

    public void clean() throws IOException {
        if (!Files.isDirectory(MetaFiles.getTempPath(), new LinkOption[0])) {
            return;
        }
        final long currentTime = System.currentTimeMillis();
        Files.walkFileTree(MetaFiles.getTempPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                long diff = currentTime - Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
                if (diff >= 86400000L) {
                    Files.deleteIfExists(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void clean(String fileId) throws IOException {
        Files.deleteIfExists(MetaFiles.getTempPath(fileId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File upload(InputStream chunk, long startOffset, long fileSize, String fileId) throws IOException {
        Path tmp = MetaFiles.getTempPath(fileId);
        if (fileSize > -1L && startOffset > fileSize || Files.exists(tmp, new LinkOption[0]) && Files.size(tmp) != startOffset || !Files.exists(tmp, new LinkOption[0]) && startOffset > 0L) {
            throw new IllegalArgumentException("Start offset is out of bound.");
        }
        Files.createDirectories(MetaFiles.getTempPath(), new FileAttribute[0]);
        try {
            this.clean();
        }
        catch (Exception exception) {
            // empty catch block
        }
        File file = tmp.toFile();
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file, startOffset > 0L));){
            int read = 0;
            long total = startOffset;
            byte[] bytes = new byte[4096];
            while ((read = chunk.read(bytes)) != -1) {
                if (fileSize > -1L && (total += (long)read) > fileSize) {
                    throw new IllegalArgumentException("Invalid chunk, oversized upload.");
                }
                bos.write(bytes, 0, read);
            }
            bos.flush();
        }
        return file;
    }

    @Transactional
    public MetaFile upload(File file) throws IOException {
        return this.upload(file, new MetaFile());
    }

    @Transactional
    public MetaFile upload(File file, MetaFile metaFile) throws IOException {
        Path tmp;
        Preconditions.checkNotNull((Object)metaFile);
        Preconditions.checkNotNull((Object)file);
        boolean update = !StringUtils.isBlank((CharSequence)metaFile.getFilePath());
        String fileName = StringUtils.isBlank((CharSequence)metaFile.getFileName()) ? file.getName() : metaFile.getFileName();
        String targetName = update ? metaFile.getFilePath() : fileName;
        Path path = MetaFiles.getUploadPath(targetName);
        Path path2 = tmp = update ? MetaFiles.createTempFile(null, null, new FileAttribute[0]) : null;
        if (update && Files.exists(path, new LinkOption[0])) {
            Files.move(path, tmp, MOVE_OPTIONS);
        }
        try {
            Path source = file.toPath();
            Path target = this.getNextPath(fileName);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            if (MetaFiles.getTempPath().equals(source.getParent())) {
                Files.move(source, target, MOVE_OPTIONS);
            } else {
                Files.copy(source, target, COPY_OPTIONS);
            }
            if (StringUtils.isBlank((CharSequence)metaFile.getFileName())) {
                metaFile.setFileName(file.getName());
            }
            if (StringUtils.isBlank((CharSequence)metaFile.getFileType())) {
                metaFile.setFileType(Files.probeContentType(target));
            }
            metaFile.setFileSize(Files.size(target));
            metaFile.setFilePath(MetaFiles.getUploadPath().relativize(target).toString());
            try {
                MetaFile metaFile2 = this.filesRepo.save(metaFile);
                return metaFile2;
            }
            catch (Exception e) {
                Files.deleteIfExists(target);
                if (tmp != null) {
                    Files.move(tmp, target, MOVE_OPTIONS);
                }
                throw new PersistenceException((Throwable)e);
            }
        }
        finally {
            if (tmp != null) {
                Files.deleteIfExists(tmp);
            }
        }
    }

    @Transactional
    public MetaFile upload(InputStream stream, MetaFile metaFile) throws IOException {
        Preconditions.checkNotNull((Object)stream, (Object)"stream can't be null");
        Preconditions.checkNotNull((Object)metaFile, (Object)"meta file can't be null");
        Preconditions.checkNotNull((Object)metaFile.getFileName(), (Object)"meta file should have filename");
        Path tmp = MetaFiles.createTempFile(null, null, new FileAttribute[0]);
        File tmpFile = this.upload(stream, 0L, -1L, tmp.toFile().getName());
        return this.upload(tmpFile, metaFile);
    }

    @Transactional
    public MetaFile upload(InputStream stream, String fileName) throws IOException {
        MetaFile file = new MetaFile();
        file.setFileName(fileName);
        return this.upload(stream, file);
    }

    @Transactional
    public DMSFile attach(InputStream stream, String fileName, Model entity) throws IOException {
        MetaFile metaFile = this.upload(stream, fileName);
        return this.attach(metaFile, fileName, entity);
    }

    @Transactional
    public DMSFile attach(MetaFile metaFile, String fileName, Model entity) {
        Preconditions.checkNotNull((Object)metaFile);
        Preconditions.checkNotNull((Object)metaFile.getId());
        Preconditions.checkNotNull((Object)entity);
        Preconditions.checkNotNull((Object)entity.getId());
        String name = StringUtils.isBlank((CharSequence)fileName) ? metaFile.getFileName() : fileName;
        DMSFile dmsFile = new DMSFile();
        DMSFileRepository repository = Beans.get(DMSFileRepository.class);
        dmsFile.setFileName(name);
        dmsFile.setMetaFile(metaFile);
        dmsFile.setRelatedId(entity.getId());
        dmsFile.setRelatedModel(EntityHelper.getEntityClass(entity).getName());
        repository.save(dmsFile);
        return dmsFile;
    }

    @Transactional
    public void delete(DMSFile file) {
        DMSFileRepository repository = Beans.get(DMSFileRepository.class);
        repository.remove(file);
    }

    public MetaAttachment attach(MetaFile file, Model entity) {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)entity);
        Preconditions.checkNotNull((Object)entity.getId());
        MetaAttachment attachment = new MetaAttachment();
        attachment.setMetaFile(file);
        attachment.setObjectId(entity.getId());
        attachment.setObjectName(EntityHelper.getEntityClass(entity).getName());
        return attachment;
    }

    @Transactional
    public void delete(MetaAttachment attachment) throws IOException {
        Preconditions.checkNotNull((Object)attachment);
        Preconditions.checkNotNull((Object)attachment.getMetaFile());
        MetaAttachmentRepository attachments = Beans.get(MetaAttachmentRepository.class);
        DMSFileRepository dms = Beans.get(DMSFileRepository.class);
        attachments.remove(attachment);
        MetaFile metaFile = attachment.getMetaFile();
        long count = dms.all().filter("self.metaFile = ?", metaFile).count();
        if (count == 0L) {
            count = attachments.all().filter("self.metaFile = ? and self.id != ?", metaFile, attachment.getId()).count();
        }
        if (count > 0L) {
            return;
        }
        this.delete(metaFile);
    }

    @Transactional
    public void delete(MetaFile metaFile) throws IOException {
        Preconditions.checkNotNull((Object)metaFile);
        Path target = MetaFiles.getUploadPath(metaFile.getFilePath());
        Path tmp = MetaFiles.createTempFile(null, null, new FileAttribute[0]);
        this.filesRepo.remove(metaFile);
        Files.move(target, tmp, MOVE_OPTIONS);
        try {
            Files.deleteIfExists(tmp);
        }
        catch (IOException e) {
            Files.move(tmp, target, new CopyOption[0]);
            throw e;
        }
    }

    @Transactional
    public void deleteAttachments(Model entity) {
        DMSFileRepository dmsFileRepo = Beans.get(DMSFileRepository.class);
        Optional.ofNullable(dmsFileRepo.findHomeByRelated(entity)).ifPresent(dmsFileRepo::remove);
    }

    public String fileTypeIcon(MetaFile file) {
        String fileType = file.getFileType();
        if (fileType == null) {
            return "fa-file-o";
        }
        switch (fileType) {
            case "application/msword": 
            case "application/vnd.openxmlformats-officedocument.wordprocessingml.document": 
            case "application/vnd.oasis.opendocument.text": {
                return "fa-file-word-o";
            }
            case "application/vnd.ms-excel": 
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": 
            case "application/vnd.oasis.opendocument.spreadsheet": {
                return "fa-file-excel-o";
            }
            case "application/vnd.ms-powerpoint": 
            case "application/vnd.openxmlformats-officedocument.presentationml.presentation": 
            case "application/vnd.oasis.opendocument.presentation": {
                return "fa-file-powerpoint-o";
            }
            case "application/pdf": {
                return "fa-file-pdf-o";
            }
            case "application/zip": 
            case "application/gzip": {
                return "fa-file-archive-o";
            }
        }
        if (fileType.startsWith("text")) {
            return "fa-file-text-o";
        }
        if (fileType.startsWith("image")) {
            return "fa-file-image-o";
        }
        if (fileType.startsWith("video")) {
            return "fa-file-video-o";
        }
        return "fa-file-o";
    }

    public String getDownloadLink(MetaFile metaFile, Model parentModel) {
        return String.format("ws/rest/%s/%d/content/download?parentModel=%s&parentId=%d", MetaFile.class.getName(), metaFile.getId(), EntityHelper.getEntityClass(parentModel).getName(), parentModel.getId());
    }
}

