/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta;

import com.axelor.common.ClassUtils;
import com.axelor.common.StringUtils;
import com.axelor.common.reflections.ClassFinder;
import com.axelor.common.reflections.Reflections;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class MetaScanner {
    private static final String MODULE_PROPERTIES = "module.properties";
    private static final String SCHEME_JAR = "jar";
    private static final List<String> BUILD_OUTPUT_PATHS = Arrays.asList("bin/main", "out/production/classes", "out/production/resources", "build/resources/main", "build/classes/main", "build/classes/java/main", "build/classes/scala/main", "build/classes/kotlin/main", "build/classes/groovy/main");

    private MetaScanner() {
    }

    private static List<URL> findModuleFiles() {
        ArrayList<URL> paths = new ArrayList<URL>();
        ClassLoader loader = ClassUtils.getDefaultClassLoader();
        try {
            Enumeration<URL> found = loader.getResources(MODULE_PROPERTIES);
            while (found.hasMoreElements()) {
                paths.add(found.nextElement());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return paths;
    }

    private static Properties findProperties(URL file) {
        Properties properties = new Properties();
        try (InputStream stream = file.openStream();){
            properties.load(stream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    private static List<URL> findClassPath(URL moduleFile) {
        Path file;
        ArrayList<URL> paths = new ArrayList<URL>();
        String scheme = moduleFile.getProtocol();
        boolean isJar = SCHEME_JAR.equals(scheme);
        String fileName = isJar ? moduleFile.getFile() : moduleFile.toString();
        fileName = fileName.substring(0, fileName.length() - MODULE_PROPERTIES.length() - (isJar ? 2 : 1));
        try {
            file = Paths.get(new URI(fileName));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (fileName.endsWith(".jar") || file.endsWith("WEB-INF/classes")) {
            try {
                paths.add(file.toUri().toURL());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            return paths;
        }
        Path base = BUILD_OUTPUT_PATHS.stream().filter(p -> file.endsWith((String)p)).findFirst().map(p -> p.replaceAll("[^/]+", "..")).map(p -> file.resolve((String)p).normalize()).get();
        try {
            paths.add(file.toUri().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        ClassLoader loader = ClassUtils.getContextClassLoader();
        if (loader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                try {
                    Path next2 = Paths.get(url.toURI());
                    if (!Files.isDirectory(next2, new LinkOption[0]) || !next2.startsWith(base)) continue;
                    paths.add(url);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        } else {
            BUILD_OUTPUT_PATHS.stream().map(base::resolve).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).forEach(next -> {
                try {
                    paths.add(next.toUri().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            });
        }
        return paths;
    }

    private static List<URL> findClassPath() {
        return MetaScanner.findModuleFiles().stream().flatMap(file -> MetaScanner.findClassPath(file).stream()).collect(Collectors.toList());
    }

    private static <T> T findWithinModules(Supplier<T> task) {
        List<URL> urls = MetaScanner.findClassPath();
        return MetaScanner.findWithinModules(urls.toArray(new URL[0]), task);
    }

    private static <T> T findWithin(String module, Supplier<T> task) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (URL file : MetaScanner.findModuleFiles()) {
            Properties info = MetaScanner.findProperties(file);
            if (!module.equals(info.getProperty("name"))) continue;
            urls.addAll(MetaScanner.findClassPath(file));
            break;
        }
        return MetaScanner.findWithinModules(urls.toArray(new URL[0]), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T findWithinModules(URL[] paths, Supplier<T> task) {
        final ClassLoader context = ClassUtils.getContextClassLoader();
        URLClassLoader wrapper = new URLClassLoader(paths, null){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return context.loadClass(name);
            }
        };
        try {
            ClassUtils.setContextClassLoader((ClassLoader)wrapper);
            T t = task.get();
            return t;
        }
        finally {
            ClassUtils.setContextClassLoader((ClassLoader)context);
        }
    }

    public static List<Properties> findModuleProperties() {
        return MetaScanner.findModuleFiles().stream().map(file -> MetaScanner.findProperties(file)).filter(p -> StringUtils.notBlank((CharSequence)p.getProperty("name"))).collect(Collectors.toList());
    }

    public static List<URL> findAll(String pattern) {
        return MetaScanner.findWithinModules(() -> Reflections.findResources().byName(pattern).find());
    }

    public static List<URL> findAll(String module, String directory, String pattern) {
        String namePattern = directory + "(/|\\\\)" + pattern;
        return MetaScanner.findWithin(module, () -> Reflections.findResources().byName(namePattern).find());
    }

    public static <T> ClassFinder<T> findSubTypesOf(Class<T> type) {
        return MetaScanner.findWithinModules(() -> Reflections.findSubTypesOf((Class)type));
    }

    public static <T> ClassFinder<T> findSubTypesOf(String module, Class<T> type) {
        return MetaScanner.findWithin(module, () -> Reflections.findSubTypesOf((Class)type));
    }
}

