/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaAction;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Cacheable
@Table(name="META_ACTION_MENU", indexes={@Index(columnList="name"), @Index(columnList="title"), @Index(columnList="parent"), @Index(columnList="action")})
public class MetaActionMenu
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_ACTION_MENU_SEQ")
    @SequenceGenerator(name="META_ACTION_MENU_SEQ", sequenceName="META_ACTION_MENU_SEQ", allocationSize=1)
    private Long id;
    private Integer priority = 0;
    @Column(name="order_seq")
    private Integer order = 0;
    @HashKey
    @Column(unique=true)
    private String xmlId;
    @NotNull
    private String name;
    @NameColumn
    @NotNull
    private String title;
    @Widget(help="Category name to group action menus.")
    private String category;
    private String module;
    private Boolean hidden = Boolean.FALSE;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaActionMenu parent;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaAction action;

    public MetaActionMenu() {
    }

    public MetaActionMenu(String name) {
        this.name = name;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getOrder() {
        return this.order == null ? 0 : this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public String getXmlId() {
        return this.xmlId;
    }

    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public Boolean getHidden() {
        return this.hidden == null ? Boolean.FALSE : this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public MetaActionMenu getParent() {
        return this.parent;
    }

    public void setParent(MetaActionMenu parent) {
        this.parent = parent;
    }

    public MetaAction getAction() {
        return this.action;
    }

    public void setAction(MetaAction action) {
        this.action = action;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaActionMenu)) {
            return false;
        }
        MetaActionMenu other = (MetaActionMenu)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getXmlId(), other.getXmlId());
    }

    public int hashCode() {
        return Objects.hash(-708986694, this.getXmlId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("priority", (Object)this.getPriority()).add("order", (Object)this.getOrder()).add("xmlId", (Object)this.getXmlId()).add("name", (Object)this.getName()).add("title", (Object)this.getTitle()).add("category", (Object)this.getCategory()).add("module", (Object)this.getModule()).add("hidden", (Object)this.getHidden()).omitNullValues().toString();
    }
}

