/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="META_FILE", indexes={@Index(columnList="fileName")})
public class MetaFile
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_FILE_SEQ")
    @SequenceGenerator(name="META_FILE_SEQ", sequenceName="META_FILE_SEQ", allocationSize=1)
    private Long id;
    @NameColumn
    @NotNull
    private String fileName;
    @NotNull
    private String filePath;
    @Widget(title="Size in bytes", readonly=true)
    private Long fileSize = 0L;
    @Widget(title="File type")
    private String fileType;
    @Widget(multiline=true)
    private String description;
    @Widget(title="Size", readonly=true)
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    @Column(name="file_size_text")
    private String sizeText;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public Long getFileSize() {
        return this.fileSize == null ? 0L : this.fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSizeText() {
        try {
            this.sizeText = this.computeSizeText();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("NPE in function field: getSizeText()", (Throwable)e);
        }
        return this.sizeText;
    }

    protected String computeSizeText() {
        if (this.fileSize == null) {
            return null;
        }
        if (this.fileSize > 1000000000L) {
            return String.format("%.2f GB", (double)this.fileSize.longValue() / 1.0E9);
        }
        if (this.fileSize > 1000000L) {
            return String.format("%.2f MB", (double)this.fileSize.longValue() / 1000000.0);
        }
        if (this.fileSize >= 1000L) {
            return String.format("%.2f KB", (double)this.fileSize.longValue() / 1000.0);
        }
        return this.fileSize + " B";
    }

    public void setSizeText(String sizeText) {
        this.sizeText = sizeText;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaFile)) {
            return false;
        }
        MetaFile other = (MetaFile)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("fileName", (Object)this.getFileName()).add("filePath", (Object)this.getFilePath()).add("fileSize", (Object)this.getFileSize()).add("fileType", (Object)this.getFileType()).add("description", (Object)this.getDescription()).omitNullValues().toString();
    }
}

